$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'Aqui, adicionamos o código do tipo de produto.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição do tipo de produto.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o tipo de produto.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('.campoValor').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let tipoproduto = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('TIPOPRODUTO', getCookie('usuario'), tipoproduto);
        window.location.href = `${BASE_URI}/tipoproduto`;
    });

    $('#txtCodigo').on('blur', async function () {
        if ($(this).val() != '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const newCodigo = await RetornaProximo('CODIGO', 'CAD_TIPO_PROD', 'CODIGO', 3)

            $(this).val(newCodigo)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (tipoproduto != '' && tipoproduto != 'create') {

        if (await liberarRegistro('TIPOPRODUTO', tipoproduto) == false) {
            window.location.href = '../tipoproduto';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"CAD_TIPO_PROD", 
                    "camposSelect":["CODIGO", "DESCRICAO", "COD_IMPORTADO", "ATIVO", "OBS", "TEMPO_PROD", "TOTAL"], 
                    "where": ["CODIGO = '${tipoproduto}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtCodIntegra').val(jsonStr.RESULT[0][0].COD_IMPORTADO);
                    $('#txtTempoProd').val(jsonStr.RESULT[0][0].TEMPO_PROD);
                    $('#txtTotal').val(jsonStr.RESULT[0][0].TOTAL);
                    $('#txtObs').val(jsonStr.RESULT[0][0].OBS);
                    $('#cbAtivo').prop('checked', jsonStr.RESULT[0][0].ATIVO == 'S')
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da composição: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    tipoClasse = {};

                    tipoClasse.CODIGO = $('#txtCodigo').val()
                    tipoClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    tipoClasse.CODIMPORTADO = $('#txtCodIntegra').val().toUpperCase();
                    tipoClasse.TEMPOPROD = $('#txtTempoProd').val().toUpperCase();
                    tipoClasse.TOTAL = $('#txtTotal').val().toUpperCase();
                    tipoClasse.OBS = $('#txtObs').val().toUpperCase();
                    tipoClasse.ATIVO = $('#cbAtivo').is(':checked') == true ? 'S' : 'N';

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/tipoproduto?', `JSON=${encodeURIComponent(JSON.stringify(tipoClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/tipoproduto`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});