$(document).ready(async function () {

  let linhaEdicao = false;

  const colunasItens = [
    { title: 'FAL', data: 'FAL' },
    { title: 'Lote', data: 'LOTE' },
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Acabamento', data: 'ACABAMENTO' },
    { title: 'Técnica', data: 'TECNICA' },
    { title: 'Pedi Fluxo', data: 'PEDIFLUXO' },
    { title: 'Tecido', data: 'TECIDO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Variante', data: 'VARIANTE' },
    { title: 'Estampa', data: 'ESTAMPA' },
    { title: 'Pedido Tinto', data: 'PEDIDOTINTO' },
    { title: 'Item Pedido Tinto', data: 'ITPEDIDOTINTO' },
    { title: 'Pedido Compra', data: 'PEDIDOCOMPRA' },
    { title: 'Item Pedido Compra', data: 'ITPEDIDOCOMPRA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Gramatura', data: 'GRAMATURA' },
    { title: 'Título do fio', data: 'TITULOFIO' },
    { title: 'Nota fiscal', data: 'NOTA' },
    { title: 'Quantidade', data: 'QTDE' },
    { title: 'Peças', data: 'PECAS' },
    { title: 'Unidade', data: 'UNIDADE' },
    { title: 'Ourelas', data: 'OURELAS' },
    { title: 'Engomar', data: 'ENGOMAR' },
    { title: 'Agulha', data: 'AGULHA' },
    { title: 'Observações', data: 'OBSERVACAO' },
    { title: 'Editar/Excluir', data: 'EXCLUIR' },
  ];

  const urlFal = $(window.location.href.split('/')).get(-1);

  await setarDataAtual('dtEmissao');

  addBotoesAvancarVoltar();
  addPesquisaAutocompleta();
  insereValor('#txtCliente', getCookie('cod_usuario') + ' - ' + getCookie('usuario'));
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '500px', undefined, colunasItens);
  addCamposObrigatorios();

  await validaEdicao();

  $('#btnConfirmarItem').on('click', function () {
    if (!validarCamposObrigatorios()) {
      return;
    }

    try {
      const item = {
        FAL: pegaValor('#txtFal'),
        LOTE: pegaValor('#txtLote'),
        TIPO: pegaValor('#rgTipo'),
        ACABAMENTO: pegaValor('#rgAcabamentoCapa'),
        TECNICA: pegaValor('#rgTecnicaCapa'),
        PEDIFLUXO: pegaChave('#txtPediFluxo'),
        TECIDO: pegaChave('#txtTecido'),
        COR: pegaChave('#txtCor'),
        VARIANTE: pegaChave('#txtVariante'),
        ESTAMPA: pegaChave('#txtEstampa'),
        PEDIDOTINTO: pegaValor('#txtPedidoTinto'),
        ITPEDIDOTINTO: pegaValor('#txtItPedTinto'),
        PEDIDOCOMPRA: pegaValor('#txtPedidoCompra'),
        ITPEDIDOCOMPRA: pegaValor('#txtItPedCompra'),
        LARGURA: pegaValor('#txtLargura'),
        GRAMATURA: pegaValor('#txtGramatura'),
        TITULOFIO: pegaValor('#txtTitFioFab'),
        NOTA: pegaValor('#txtNf'),
        QTDE: pegaValor('#txtQuantidade'),
        PECAS: pegaValor('#txtPecas'),
        UNIDADE: pegaValor('#rgUnidade'),
        OURELAS: pegaValor('#rgOurelas'),
        ENGOMAR: pegaValor('#rgEngomar'),
        AGULHA: pegaValor('#rgAgulha'),
        OBSERVACAO: montaObsItem(),
        EXCLUIR: retornaBotaoExcluir(),
      };

      if (linhaEdicao) {
        $("#tabelaItens").DataTable().row(linhaEdicao).remove().draw(false);
        linhaEdicao = false;
      }

      $('#tabelaItens').DataTable().row.add(item).draw(false);
    } finally {
      calculaTotais();
      $('#modalAddItem').modal('hide');
    }
  });

  $('#btnAddItem').on('click', async function () {
    window.event.preventDefault();
    limpaCampos();
    $("#rgFichaTecnica").html('<option value="">Selecione uma opção</option>');
    linhaEdicao = false;
    insereValor('#txtFal', await RetornaProximo("FAL", "FAL", "NUMERO", 5));
    $('#modalAddItem').modal('show');
  });

  $('#tabelaItens').on('click', '#btn-excluir', async function () {
    $("#tabelaItens").DataTable().row($(this).parents("tr")).remove().draw(false);
    calculaTotais();
  });

  $('#txtEstampa').on('blur', async function () {
    const estampa = $(this).val();

    if ((estampa.charAt() == '') || (estampa.charAt() == '[')) {
      return;
    }

    await buscaDescricaoEstampa(estampa);
  });

  $('#txtCor').on('blur', async function () {
    const cor = $(this).val();

    if ((cor.charAt() == '') || (cor.charAt() == '[')) {
      return;
    }

    await buscaDescricaoCor(cor);
  });

  $('#tabelaItens').on('click', '#btn-editar', async function () {
    linhaEdicao = $(this).parents("tr");
    await editaItem(linhaEdicao);
  });

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/servtingimento`;
  });

  $('#btnGravar').on('click', async function () {
    if ($('#tabelaItens').DataTable().rows().length == 0) {
      msgAlerta('Necessário adicionar pelo menos um item a solicitação.')
      return;
    }

    await gravaDados();
  });

  $(".maskItens").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtPecas").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 0,
  });

  $('#txtTecido').on('blur', async function () {
    const material = pegaChave('#txtTecido');

    if (material == '') {
      limpaFts();
      return;
    }

    await carregaFts();
  });

  $('#txtLote').on('blur', async function () {
    const lote = pegaValor('#txtLote');

    if (lote == '') {
      return;
    }

    const objPesquisa = {
      tabela: 'FAL_ITEN',
      camposSelect: ['FAL_ITEN.LOTE'],
      leftJoin: [{ tabela: 'FAL', condicao: 'FAL.NUMERO = FAL_ITEN.FAL' }],
      where: [`FAL.CLIENTE = '${getCookie('cod_usuario')}' AND FAL_ITEN.LOTE = '${lote}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(objPesquisa));

    if (jsonStr.length > 0) {
      $('#txtLote').val('');
      msgAlerta('Lote já utilizado, favor verificar.');
      return;
    }
  });

  $('#rgFichaTecnica').on('change', function () {
    if ($(this).val() == '') {
      limpaFts(false);
    }

    validaFt();
  });

  $('#cbDefinirEstampa').on('click', function () {
    if (!isChecked('#cbDefinirEstampa')) {
      $('.camposTecnicaAcabamento').addClass('d-none');
      return;
    }
    $('.camposTecnicaAcabamento').removeClass('d-none');

    const obs = pegaValor('#txtObsItem');

    if (obs.indexOf('ESTAMPA A DEFINIR') == -1) {
      $('#txtObsItem').val($('#txtObsItem').val() + ' - ESTAMPA A DEFINIR - ');
    }
  });

  $('#txtPediFluxo').on('blur', async function () {
    const fluxo = pegaValor('#txtPediFluxo');

    if (fluxo == '') {
      return;
    }

    $("#rgFichaTecnica").html('<option value="">Selecione uma opção</option>');
    await carregaFts();
  });

  function validarCamposObrigatorios() {
    if (isChecked('#cbDefinirEstampa') && ((pegaValor('#rgTecnicaCapa') == '0') || (pegaValor('#rgAcabamentoCapa') == '0'))) {
      msgAlerta('Necessário selecionar a técnica e o acabamento antes de prosseguir.');
      return;
    };

    const validator = $("#formValidate").validate();

    validator.element("#txtLote");
    validator.element("#txtTecido");
    validator.element("#txtCor");
    validator.element("#txtQuantidade");
    validator.element("#txtPecas");
    validator.element("#txtPediFluxo");

    if (validator.element("#txtLote") && validator.element("#txtTecido") && validator.element("#txtCor") && validator.element("#txtQuantidade") && validator.element("#txtPecas") && validator.element("#txtPediFluxo")) {
      return true;
    }

    msgAlerta('Necessário informar todos os campos obrigatórios, favor verificar.');
    return false;
  }

  function calculaTotais() {
    let totQtde = 0;
    let totRolos = 0;
    const totalLinhas = $('#tabelaItens').DataTable().data().length;
    $('#tabelaItens').DataTable().rows().data().map(item => {
      totQtde += item.QTDE != '' ? parseFloat(item.QTDE) : 0;
      totRolos += item.PECAS != '' ? parseFloat(item.PECAS) : 0;
    });
    $('#txtTotQtde').val(totQtde);
    $('#txtTotRolos').val(totRolos);
    $('#txtCountFals').val(totalLinhas);
  }

  function montaObsItem() {
    return (pegaValor('#txtObsItem') + ' - OURELAS: ' + pegaValor('#rgOurelas') + ' - ENGOMAR: ' + pegaValor('#rgEngomar') + ' - AGULHA: ' + pegaValor('#rgAgulha'));
  };

  function limpaFts(bZera = true) {
    if (bZera) {
      $("#rgFichaTecnica").html('<option value="">Selecione uma opção</option>');
    }

    $('#txtLargura').val('');
    $('#txtGramatura').val('');

    $('#txtPediFluxo').autocompleta(1, `JSON={ "tabela":"FLUXOTIN", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $("#btnPediFluxo").pesquisa_serverside(["#txtPediFluxo"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"FLUXOTIN", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Pedi Fluxo");

    $('#txtPediFluxo').on('blur', async function () {
      const fluxo = pegaValor('#txtPediFluxo');

      if (fluxo == '') {
        return;
      }

      $("#rgFichaTecnica").html('<option value="">Selecione uma opção</option>');
      await carregaFts();
    });
  };

  function limpaCampos() {
    limpaValor('#txtLote');
    limpaValor('#txtTecido');
    limpaValor('#txtCor');
    limpaValor('#txtEstampa');
    limpaValor('#txtPedidoTinto');
    limpaValor('#txtItPedTinto');
    limpaValor('#txtPedidoCompra');
    limpaValor('#txtItPedCompra');
    limpaValor('#txtLargura');
    limpaValor('#txtGramatura');
    limpaValor('#txtTitFioFab');
    limpaValor('#txtNf');
    limpaValor('#txtQuantidade');
    limpaValor('#txtPecas');
    limpaValor('#txtObsItem');
    limpaValor('#txtPediFluxo');
    $('#rgTecnicaCapa').val('0').change();
    $('#rgAcabamentoCapa').val('0').change();
    $('.camposTecnicaAcabamento').addClass('d-none');
  }

  async function buscaDescricaoEstampa(estampa) {
    const pesquisaParam = {
      tabela: 'CILINDRO_VAR',
      camposSelect: [
        `CONCAT(COR_ESTAMPA, '-', VARIANTE) AS COR_ESTAMPA`, 'DESCRICAO'
      ],
      where: [`CONCAT(COR_ESTAMPA, '-', VARIANTE) = '${estampa}' AND ((CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '0') OR (EXCLUSIV = '1') OR (CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '2' AND DT_UTIL_EXCLUSIV > '${pegaValor('#dtEmissao')}'))`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      $('#txtEstampa').val('');
      msgAlerta('Código de estampa informada incorreto, favor verificar.', undefined, undefined, () => { $('#txtEstampa').focus(); });
      return;
    }

    insereValor('#txtEstampa', jsonStr[0].COR_ESTAMPA, jsonStr[0].DESCRICAO);
  };

  async function buscaDescricaoCor(cor) {
    const pesquisaParam = {
      tabela: 'CADCORTIN',
      camposSelect: ['DESCRICAO'],
      where: [`CODIGO = '${cor}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      $('#txtCor').val('');
      msgAlerta('Código de cor informada incorreto, favor verificar.', undefined, undefined, () => { $('#txtCor').focus(); });
      return;
    }

    insereValor('#txtCor', cor, jsonStr[0].DESCRICAO);
  };

  async function editaItem(linha) {
    $.LoadingOverlay('show');
    try {
      const dados = $("#tabelaItens").DataTable().row(linha).data();

      limpaCampos();
      insereValor('#txtFal', dados.FAL);
      insereValor('#txtLote', dados.LOTE);
      insereValor('#txtPedidoTinto', dados.PEDIDOTINTO);
      insereValor('#txtItPedTinto', dados.ITPEDIDOTINTO);
      insereValor('#txtPedidoCompra', dados.PEDIDOCOMPRA);
      insereValor('#txtItPedCompra', dados.ITPEDIDOCOMPRA);
      insereValor('#txtLargura', dados.LARGURA);
      insereValor('#txtGramatura', dados.GRAMATURA);
      insereValor('#txtTitFioFab', dados.TITULOFIO);
      insereValor('#txtNf', dados.NOTA);
      insereValor('#txtQuantidade', dados.QTDE);
      insereValor('#txtPecas', dados.PECAS);
      insereValor('#txtVariante', dados.VARIANTE);

      $('#rgTipo').val(dados.TIPO).change();
      $('#rgAcabamentoCapa').val(dados.ACABAMENTO).change();
      $('#rgTecnicaCapa').val(dados.TECNICA).change();
      $('#rgUnidade').val(dados.UNIDADE).change();
      $('#rgOurelas').val(dados.OURELAS).change();
      $('#rgEngomar').val(dados.ENGOMAR).change();
      $('#rgAgulha').val(dados.AGULHA).change();

      if ((dados.ACABAMENTO != '0') || (dados.TECNICA != '0')) {
        $('.camposTecnicaAcabamento').removeClass('d-none');
      }

      if (dados.TECIDO != '') {
        await insereValor('#txtTecido', dados.TECIDO, (await buscaValor('MATERIAL', 'DESCRICAO', 'CODIGO', dados.TECIDO)).DESCRICAO);
      }

      if (dados.COR != '') {
        await insereValor('#txtCor', dados.COR, (await buscaValor('CADCORTIN', 'DESCRICAO', 'CODIGO', dados.COR)).DESCRICAO);
      }

      if (dados.ESTAMPA != '') {
        await insereValor('#txtEstampa', dados.ESTAMPA, (await buscaValor('CADCOR', 'DESCRICAO', 'COR', dados.ESTAMPA)).DESCRICAO);
      }

      if (dados.PEDIFLUXO != '') {
        await insereValor('#txtPediFluxo', dados.PEDIFLUXO, (await buscaValor('FLUXOTIN', 'DESCRICAO', 'CODIGO', dados.PEDIFLUXO)).DESCRICAO);
      }

      $('#txtPediFluxo').autocompleta(1, `JSON={ "tabela":"COMP_MATERIAL", "camposSelect":[ "COMP_MATERIAL.FLUXO chave", "FLUXOTIN.DESCRICAO descricao"], "leftJoin": [{"tabela": "FLUXOTIN", "condicao": "COMP_MATERIAL.FLUXO = FLUXOTIN.CODIGO"}], "where": ["COMP_MATERIAL.CODCLI = '${getCookie('cod_usuario')}' AND COMP_MATERIAL.CODIGO = '${dados.TECIDO}'"], "groupBy": ["COMP_MATERIAL.FLUXO", "FLUXOTIN.DESCRICAO"]}`);
      $("#btnPediFluxo").pesquisa_serverside(["#txtPediFluxo"], ["COMP_MATERIAL.FLUXO"], ["FLUXOTIN.DESCRICAO"], `{"tabela":"COMP_MATERIAL", "camposSelect":[ "COMP_MATERIAL.FLUXO", "FLUXOTIN.DESCRICAO" ], "leftJoin": [{"tabela": "FLUXOTIN", "condicao": "COMP_MATERIAL.FLUXO = FLUXOTIN.CODIGO"}], "where": ["COMP_MATERIAL.CODCLI = '${getCookie('cod_usuario')}' AND COMP_MATERIAL.CODIGO = '${dados.TECIDO}'"], "groupBy": ["COMP_MATERIAL.FLUXO", "FLUXOTIN.DESCRICAO"]}`, "Pesquisa Pedi Fluxo");

    } finally {
      $.LoadingOverlay('hide');
      $('#modalAddItem').modal('show');
    }
  }

  async function carregaFts() {
    const material = pegaChave('#txtTecido');
    const fluxo = pegaChave('#txtPediFluxo');

    const pesquisaParam = {
      tabela: 'COMP_MATERIAL',
      camposSelect: ['NUM_CONTROLE', 'LARGURA', 'GRAMATURA', 'FLUXO'],
      where: [`MATERIAL = '${material}' AND CODCLI = '${getCookie('cod_usuario')}' ${fluxo != '' ? `AND FLUXO = '${fluxo}'` : ''}`]
    };

    const jsonFt = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonFt.length == 0) {
      limpaFts();
      return;
    }

    $("#rgFichaTecnica").html('<option value="">Selecione uma opção</option>');

    jsonFt.map(item => {
      $('#rgFichaTecnica').append(
        $(
          '<option>',
          {
            value: item.NUM_CONTROLE,
            text: item.NUM_CONTROLE,
            largura: item.LARGURA,
            gramatura: item.GRAMATURA
          }
        )
      );
    });

    $("#rgFichaTecnica").prop("selectedIndex", 1).change();

    $('#txtPediFluxo').autocompleta(1, `JSON={ "tabela":"COMP_MATERIAL", "camposSelect":[ "COMP_MATERIAL.FLUXO chave", "FLUXOTIN.DESCRICAO descricao"], "leftJoin": [{"tabela": "FLUXOTIN", "condicao": "COMP_MATERIAL.FLUXO = FLUXOTIN.CODIGO"}], "where": ["COMP_MATERIAL.CODCLI = '${getCookie('cod_usuario')}' AND COMP_MATERIAL.CODIGO = '${material}'"], "groupBy": ["COMP_MATERIAL.FLUXO", "FLUXOTIN.DESCRICAO"]}`);
    $("#btnPediFluxo").pesquisa_serverside(["#txtPediFluxo"], ["COMP_MATERIAL.FLUXO"], ["FLUXOTIN.DESCRICAO"], `{"tabela":"COMP_MATERIAL", "camposSelect":[ "COMP_MATERIAL.FLUXO", "FLUXOTIN.DESCRICAO" ], "leftJoin": [{"tabela": "FLUXOTIN", "condicao": "COMP_MATERIAL.FLUXO = FLUXOTIN.CODIGO"}], "where": ["COMP_MATERIAL.CODCLI = '${getCookie('cod_usuario')}' AND COMP_MATERIAL.CODIGO = '${material}'"], "groupBy": ["COMP_MATERIAL.FLUXO", "FLUXOTIN.DESCRICAO"]}`, "Pesquisa Pedi Fluxo");

    $('#txtPediFluxo').on('blur', async function () {
      const fluxo = pegaValor('#txtPediFluxo');

      if (fluxo == '') {
        return;
      }

      $("#rgFichaTecnica").html('<option value="">Selecione uma opção</option>');
      await carregaFts();
    });

    validaFt();
  };

  function validaFt() {
    insereValor('#txtLargura', $("#rgFichaTecnica :selected").attr('largura'));
    insereValor('#txtGramatura', $("#rgFichaTecnica :selected").attr('gramatura'));

    $('#txtLargura').prop('disabled', true);
    $('#txtGramatura').prop('disabled', true);
  };

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      const fal = {
        SOLICITACAO: pegaValor('#txtSolicitacao'),
        EMP_ID: getCookie('emp_id'),
        DATA_INI: pegaValor('#dtEmissao'),
        OBS: pegaValor('#txtObservacoes'),
        STATUS: pegaValor('#txtStatus'),
        FAT_PED_COMPLETO: isChecked('#cbFatPedidoCompleto') ? 'S' : 'N',
        COR: $('#tabelaItens').DataTable().rows().data()[0].COR,
        COR_ESTAMPA: $('#tabelaItens').DataTable().rows().data()[0].ESTAMPA,
        ITENS: retornaItensFal(),
        CLIENTE: pegaValor('#txtCliente').split(' - ')[0],
        PRAZO: '00'
      }

      const response = await requisicao('POST', '/sisplan/fal/v1/fal?', '', JSON.stringify(fal));

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      const jsonStr = await response.json();

      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      msgAlerta('Deseja imprimir a solicitação?',
        async () => { await imprimirSolicitacao(pegaValor('#txtSolicitacao')); callBack(); },
        () => { callBack(); },
        () => { },
        () => { callBack(); });

      function callBack() {
        criaMensagemSucesso(`Solicitação: ${fal.SOLICITACAO} cadastrada com sucesso!`, async () => { window.location.href = `${BASE_URI}/servtingimento` });
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  const imprimirSolicitacao = async (solicitacao) => {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/impressao/v1/imprimirtingimentoindividual?`;

      const filtros = `NUMERO=${solicitacao}&SOLICITACAO=S`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelTingimentoSolicitacao');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelTingimentoSolicitacao');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function retornaItensFal() {
    let arrItens = [];
    $('#tabelaItens').DataTable().rows().data().map(item => {
      arrItens.push(item);
    });
    return arrItens;
  };

  async function validaEdicao() {
    if (urlFal == 'create') {
      insereValor('#txtSolicitacao', await RetornaProximo("FAL", "FAL", "SOL_PORTAL", 5));
      $('#txtSolicitacao').prop('disabled', true);
      $('#txtStatus').val('N');
      insereValor('#txtSolicitacaoVisu', pegaValor('#txtSolicitacao'));
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaFalIt = {
        tabela: 'FAL_ITEN',
        camposSelect: [
          'FAL', 'LOTE', 'TIPO', 'ACABAMENTO', 'PEDIFLUXO', 'TECIDO', 'COR', 'VARIANTE',
          'ESTAMPA', 'PEDIDOTINTO', 'ITPEDIDOTINTO', 'PEDIDOCOMPRA', 'ITPEDIDOCOMPRA',
          'LARGURA', 'GRAMATURA', 'TITULOFIO', 'NOTA', 'QTDE', 'PECAS', 'UNIDADE',
          'OURELAS', 'ENGOMAR', 'AGULHA', 'OBSERVACAO'
        ],
        where: [`FAL = '${urlFal}' AND EMP_ID = ${getCookie('emp_id')}`]
      };

      const jsonStrFalIt = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaFalIt));

      const pesquisaParam = {
        tabela: 'FAL',
        camposSelect: [
          'DATA_INI', 'OBS_SOL', 'STATUS', 'FAT_PED_COMPLETO', 'SOL_PORTAL', 'ACABAMENTO', 'TECNICA'
        ],
        where: [`NUMERO = '${urlFal}' AND EMP_ID = ${getCookie('emp_id')}`]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      let qtdeTotal = 0;

      jsonStrFalIt.map(item => {
        qtdeTotal += item.QTDE;
        item.EXCLUIR = retornaBotaoExcluir();
        item.ACABAMENTO = jsonStr[0].ACABAMENTO;
        item.TECNICA = jsonStr[0].TECNICA;
        $('#tabelaItens').DataTable().row.add(item).draw(false);
      });

      calculaTotais();

      $('#txtNumero').prop('disabled', true);
      $('#dtEmissao').prop('disabled', true);
      insereValor('#txtNumero', urlFal);
      insereValor('#txtQtdeTotal', qtdeTotal);

      insereValor('#txtSolicitacao', jsonStr[0].SOL_PORTAL);
      insereValor('#dtEmissao', jsonStr[0].DATA_INI);
      insereValor('#txtObservacoes', jsonStr[0].OBS_SOL);
      insereValor('#txtStatus', jsonStr[0].STATUS);
      insereValor('#txtSolicitacaoVisu', jsonStr[0].SOL_PORTAL);
      $('#cbFatPedidoCompleto').prop('checked', jsonStr[0].FAT_PED_COMPLETO == 'S');

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function addPesquisaAutocompleta() {
    $('#txtTecido').autocompleta(3, `JSON={ "tabela":"COMP_MATERIAL", "camposSelect":["COMP_MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela": "MATERIAL", "condicao": "COMP_MATERIAL.CODIGO = MATERIAL.CODIGO"}], "where": ["COMP_MATERIAL.CODCLI = '${getCookie('cod_usuario')}'"], "groupBy": ["COMP_MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]}`);
    $("#btnTecido").pesquisa_serverside(["#txtTecido"], ["COMP_MATERIAL.CODIGO"], ["MATERIAL.DESCRICAO"], `{ "tabela":"COMP_MATERIAL", "camposSelect":["COMP_MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela": "MATERIAL", "condicao": "COMP_MATERIAL.CODIGO = MATERIAL.CODIGO"}], "where": ["COMP_MATERIAL.CODCLI = '${getCookie('cod_usuario')}'"], "groupBy": ["COMP_MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]}`, "Pesquisa Material");
    // $('#txtTecido').autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "where": ["MATERIAL.CODCLI = '${getCookie('cod_usuario')}'"]}`);
    // $("#btnTecido").pesquisa_serverside(["#txtTecido"], ["MATERIAL.CODIGO"], ["MATERIAL.DESCRICAO"], `{ "tabela":"MATERIAL", "camposSelect":["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "where": ["MATERIAL.CODCLI = '${getCookie('cod_usuario')}'"]}`, "Pesquisa Material");
    $('#btnATecido').on('click', function () {
      $('#txtTecido').val('');
      limpaFts();
    });

    // $('#txtCor').autocompleta(3, `JSON={ "tabela":"CADCORTIN", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $("#btnCor").pesquisa_serverside(["#txtCor"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CADCORTIN", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Cor");
    $('#btnACor').on('click', function () { $('#txtCor').val(''); });

    $('#txtVariante').autocompleta(1, `JSON={ "tabela":"VARIANTE", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $("#btnVariante").pesquisa_serverside(["#txtVariante"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"VARIANTE", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Variante");
    $('#btnAVariante').on('click', function () { $('#txtVariante').val('') });

    // $('#txtEstampa').autocompleta(3, `JSON={ "tabela":"CILINDRO_VAR", "camposSelect":["CONCAT(COR_ESTAMPA, '-', VARIANTE) CHAVE", "DESCRICAO"], "where": ["((CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '0') OR (EXCLUSIV = '1') OR (CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '2' AND DT_UTIL_EXCLUSIV > '${pegaValor('#dtEmissao')}'))"], "groupby": ["COR_ESTAMPA", "VARIANTE", "DESCRICAO"]}`);
    // $('#btnEstampa').pesquisa_serverside(["#txtEstampa"], ["COR_ESTAMPA"], ["DESCRICAO"], `{"tabela":"CILINDRO_VAR", "camposSelect":[ "CONCAT(COR_ESTAMPA, '-', VARIANTE) AS COR_ESTAMPA", "DESCRICAO" ], "where": ["((CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '0') OR (EXCLUSIV = '1') OR (CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '2' AND DT_UTIL_EXCLUSIV > '${pegaValor('#dtEmissao')}'))"], "groupby": ["COR_ESTAMPA", "VARIANTE", "DESCRICAO"]}`, "Pesquisa Estampa");
    $('#btnEstampa').pesquisa_serverside(['#txtEstampa'], ["COR_ESTAMPA"], ["DESCRICAO"], `{
      "tabela":"CILINDRO_VAR", 
      "camposSelectSubSelect": ["COR_ESTAMPA", "DESCRICAO"],
      "camposSelect":[
          "CONCAT(COR_ESTAMPA, '-', VARIANTE) AS COR_ESTAMPA", 
          "DESCRICAO"
      ], 
      "groupby": ["COR_ESTAMPA", "VARIANTE", "DESCRICAO"],
      "groupBySubSelect": ["COR_ESTAMPA", "DESCRICAO"],
      "where": ["((CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '0') OR (EXCLUSIV = '1') OR (CODCLI = '${getCookie('cod_usuario')}' AND EXCLUSIV = '2' AND DT_UTIL_EXCLUSIV > '${pegaValor('#dtEmissao')}'))"],
      "whereSubSelect": ["1=1"]
    }`, "Pesquisa Estampa");
    // $('#txtEstampa').autocompleta(3, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["(TIPO_COR = 'D' OR TIPO_COR = 'R')"]}`);
    // $("#btnEstampa").pesquisa_serverside(["#txtEstampa"], ["COR"], ["DESCRICAO"], `{"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": ["(TIPO_COR = 'D' OR TIPO_COR = 'R')"]}`, "Pesquisa Estampa");
    $('#btnAEstampa').on('click', function () { $('#txtEstampa').val(''); });

    $('#txtPediFluxo').autocompleta(1, `JSON={ "tabela":"FLUXOTIN", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $("#btnPediFluxo").pesquisa_serverside(["#txtPediFluxo"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"FLUXOTIN", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Pedi Fluxo");
    $('#btnAPediFluxo').on('click', function () { $('#txtPediFluxo').val('') });
  };

  function retornaBotaoExcluir() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-pencil-alt" style="color:blue"></span></button>  ' +
      '       <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  };

  function addCamposObrigatorios() {
    $("#formValidate").validate({
      debug: false,
      ignore: "",
      rules: {
        txtLote: {
          required: true,
        },
        txtTecido: {
          required: true,
        },
        txtLote: {
          required: true,
        },
        txtCor: {
          required: true,
        },
        txtQuantidade: {
          required: true,
        },
        txtPecas: {
          required: true,
        },
        txtPediFluxo: {
          required: true,
        },
      },
      messages: {
        txtLote: {
          required: "Informe um lote válido.",
        },
        txtTecido: {
          required: "Informe um tecido válido.",
        },
        txtCor: {
          required: "Informe uma cor válida.",
        },
        txtQuantidade: {
          required: "Informe uma quantidade válida.",
        },
        txtPecas: {
          required: "Informe uma qtde de peças válida.",
        },
        txtPediFluxo: {
          required: "Informe um fluxo válido.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

  function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();
      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      // $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      // $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };
});