$(document).ready(async function () {

  let options = {
    series: [{
      name: "Quantidade",
      data: [{}]
    }],
    chart: {
      type: 'line',
      height: 300,
      zoom: {
        enabled: false
      }
    },
    dataLabels: {
      enabled: false
    },
    stroke: {
      curve: 'straight'
    },
    title: {
      text: 'Product Trends by Month',
      align: 'left'
    },
    title: {
      text: 'Vendas do item selecionado',
    },
    fill: {
      colors: ['#75BE25']
    }
  };

  let optionsProducao = {
    series: [{
      name: "Quantidade",
      data: [{}]
    }],
    chart: {
      type: 'bar',
      height: 300
    },
    tooltip: {
      x: {
        formatter: function (val) {
          return val;
        }
      }
    },
    xaxis: {
      type: 'category',
      labels: {
        formatter: function (val) {
          return val.split(' - ')[0];
        }
      }
    },
    title: {
      text: 'Quantidade produzida do item ',
    },
    fill: {
      colors: ['#75BE25']
    }
  };

  let listaOrdenacao = [];
  let grid;

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.curvaCliente == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, curvaCliente: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  setarDataAtual('txtDataVendasAte');

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, curvaCliente: novasColunas }))

      $('#tabelaRelCurvaCliente').DataTable().columns().visible(true);

      $('#tabelaRelCurvaCliente').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  adicionarConteudoModal(
    'Curva Cliente', [
    {
      tipo: 'paragrafo',
      valor: 'Este relatório apresenta a curva de vendas do Cliente com base na coleção informada (que é obrigatória para consulta), com possibilidade de realizar ' +
        'filtros por clientes, grupos de clientes, vendedor, entre outros campos, filtrando também um período de vendas.'
    },
    {
      tipo: 'paragrafo',
      valor: 'O gráfico representa a linha/curva em quantidades de vendas.',
    },
    {
      tipo: 'paragrafo',
      valor: 'O total de vendas dividido pelo total de vendas do cliente específico resulta no desempenho que determinado cliente teve dentro do período de vendas e da coleção informada.'
    }
  ]
  );

  componenteFiltro('cliente', true);
  componenteFiltro('vendedor', true);
  componenteFiltro('grupoCli', true);
  componenteFiltro('etiqueta', true);
  componenteFiltro('linha', true);
  componenteFiltro('marca', true);
  componenteFiltro('depositoUsuario', true);
  componenteFiltro('tipoVenda', true);
  componenteFiltro('colecao', true);

  preencheOrdenacaoTela('CurvaCliente');

  limparFiltros(true);

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/relcurvacliente?`;
        let params = await retornaFiltros();

        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros(codigo) {
    const filtros = {
      venda_de: $('#txtDataVendasDe').val(),
      venda_ate: $('#txtDataVendasAte').val(),
      colecao: await formataListas($('#txtColecao').val().toString()),
      grupo: await formataListas($('#txtGrupoCli').val().toString()),
      empresas: $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')],
      emitido: $('#cbEmitido').prop('checked'),
      pendente: $('#cbPendente').prop('checked'),
      agrupado: $('#cbAgrupada').prop('checked'),
      devolvido: $('#cbDevolvido').prop('checked'),
      cancelado: $('#cbCancelada').prop('checked'),
      tipovenda: await formataListas($('#txtTipoVenda').val().toString()),
      cliente: await formataListas($('#txtCliente').val().toString()),
      vendedor: await formataListas($('#txtVendedor').val().toString()),
      marca: await formataListas($('#txtMarca').val().toString())
    }

    const params = `PERIODODE=${filtros.venda_de}&` +
      `PERIODOATE=${filtros.venda_ate}&` +
      `GRUPOCLI=${filtros.grupo}&` +
      `COLECAO=${filtros.colecao}&` +
      `EMPRESAS_FILTRO=${filtros.empresas}&` +
      `EMITIDA=${filtros.emitido}&` +
      `PENDENTE=${filtros.pendente}&` +
      `AGRUPADA=${filtros.agrupado}&` +
      `DEVOLUCAO=${filtros.devolvido}&` +
      `CANCELADA=${filtros.cancelado}&` +
      `TIPO_VENDA=${filtros.tipovenda}&` +
      `CLIENTE=${filtros.cliente}&` +
      `VENDEDOR=${filtros.vendedor}&` +
      `MARCA=${filtros.marca}`;

    return params;
  };

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#txtDataVendasDe').val() == '') {
          msgAlerta('Data não informada ou inválida')
          return;
        } else if ($('#txtColecao').val() == '') {
          msgAlerta('Coleção não informada, necessário selecionar uma coleção!', undefined, undefined, () => { $('#modal-filtros').modal('show') });
          return;
        }

        let dataSetCols = [];
        listaOrdenacao = [];
        const url = '/sisplan/impressao/v1/relcurvacliente?';
        const params = await retornaFiltros();

        const response = await requisicao('GET', url, params, null, 150000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          return;
        }

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        const keys = jsonStr.map((key) => {

          let mediaDesempenhoProduto = key.DESEMPENHO;

          if ((mediaDesempenhoProduto == Infinity) || (isNaN(mediaDesempenhoProduto))) {
            mediaDesempenhoProduto = 0
          };

          return {
            ...key, DESEMPENHO: String(TruncaDecimaisNova(2, mediaDesempenhoProduto)) + '%'
          }
        });

        Object.keys(jsonStr[0]).forEach(k => {
          k = { data: k, title: k }

          switch (k.data) {
            case 'QUANTIDADE_VENDIDA':
              k.title = 'VENDAS'
              break;
            default:
              break;
          }

          dataSetCols.push({
            'title': formataTitleHeader(k.title, false),
            'data': k.data
          });
        });

        let colunas = Object.keys(jsonStr[0]);
        const campos = ['QTDE_PROD', 'VARIANTES', 'MEDIA_COR', 'TOTAL', 'DESEMPENHO'];
        const indiceDireita = [];

        for (let i = 0; i < colunas.length; i++) {
          if (campos.includes(colunas[i])) {
            if ((colunas[i] == 'TOTAL') || (colunas[i] == 'DESEMPENHO')) {
              indiceDireita.push(i - 2);
            } else {
              indiceDireita.push(i);
            }
          }

          if (colunas[i] == 'MEDIA_COR') {
            indiceMedia = i;
          }

          if (colunas[i] == 'TOTAL') {
            indiceTotal = i - 2;
          }
        }

        let colunasDireita = [2, 3, 4];
        for (let x = 5; x < dataSetCols.length; x++) {
          colunasDireita.push(x);
        };

        if ($.fn.DataTable.isDataTable('#tabelaRelCurvaCliente')) {
          $('#tabelaRelCurvaCliente').DataTable().destroy();
          $('#tabelaRelCurvaCliente').empty();
        }

        if ($.fn.DataTable.isDataTable('#tabelaOrdemProducao')) {
          $('#tabelaOrdemProducao').DataTable().destroy();
          $('#tabelaOrdemProducao').empty();
        }

        let colunasAzul = [2, 3];
        let colunasVerde = [4]
        let contador = 0;
        for (let x = 5; x < dataSetCols.length; x++) {
          contador++;
          if (contador === 1 || contador === 2) { colunasAzul.push(x); }
          else if (contador === 3) { colunasVerde.push(x); contador = 0; };
        };

        const cores = {
          verde: '#28a745',
          azul: '#3ca2d3',
          vermelho: 'red'
        }


        $('#tabelaRelCurvaCliente').DataTable({
          search: true,
          filter: true,
          order: [],
          sort: true,
          scrollX: true,
          scrollY: '30vh',
          scrollCollapse: true,
          fixedColumns: {
            leftColumns: 5,
            heightMatch: 'none'
          },
          destroy: true,
          "data": keys,
          "columns": dataSetCols,
          autoWidth: true,
          "colReorder": true,
          columnDefs: [
            {
              "targets": colunasDireita,
              "className": 'pr-4 text-right'
            },
            {
              targets: colunasAzul,
              createdCell: function (td, cellData) {
                if (cellData >= 0) {
                  $(td).css({
                    'color': cores.azul,
                    'font-weight': 'bold'
                  });
                } else {
                  $(td).css({
                    'color': cores.vermelho,
                    'font-weight': 'bold'
                  });
                };
              }
            },
            {
              targets: colunasVerde,
              createdCell: function (td, cellData) {
                if (cellData >= 0) {
                  $(td).css({
                    'color': cores.verde,
                    'font-weight': 'bold',
                  });
                } else {
                  $(td).css({
                    'color': cores.vermelho,
                    'font-weight': 'bold',
                  });
                };
              }
            }
          ],
          createdRow: function (row, data, dataIndex) {
            const cells = $(row).children('td').slice(5);

            cells.each(function (index) {
              const grupo = Math.floor(index / 3) % 2 === 0;
              if (grupo) {
                $(this).addClass('corDestaque');
              }
              const posicaoNoGrupo = index % 3;
              if (posicaoNoGrupo === 0) {
                $(this).addClass('borda-esquerda');
              }
            });
          }
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $("#tabelaRelCurvaCliente_filter").prepend(`
          ${$('#cbDevolvido').prop('checked') || $('#cbCancelada').prop('checked') ?
            `<div style="margin: 5px 20px 0px 0px" class="d-flex align-items-center">
              <div class="quadrado" style="background: ${cores.vermelho};">
              </div>
              <span> ${$('#cbDevolvido').prop('checked') && !$('#cbCancelada').prop('checked') ? "Devolvido"
              : !$('#cbDevolvido').prop('checked') && $('#cbCancelada').prop('checked') ? "Cancelado"
                : "Devolução/Cancelamento"
            } </span>
            </div>`
            : ""
          }
          <div style="margin: 5px 20px 0px 0px" class="d-flex align-items-center">
            <div class="quadrado" style="background: ${cores.azul};">
            </div>
            <span> Total Quantitativo </span>
          </div>
          <div style="margin: 5px 40px 0px 0px" class="d-flex align-items-center">
            <div class="quadrado" style="background: ${cores.verde};">
            </div>
            <span> Total Valor </span>
          </div>
        `);

        $($('#tabelaRelCurvaCliente').find('th')[2]).prop('title', 'Quantidade Produção');
        $($('#tabelaRelCurvaCliente').find('th')[3]).prop('title', 'Quantidade de Cores Vendidas');
        $($('#tabelaRelCurvaCliente').find('th')[4]).prop('title', 'Quantidade Produção dividido Variantes');
        const tabela = $('#tabelaRelCurvaCliente').DataTable();
        const numeroDeColunas = tabela.columns().count();
        $($('#tabelaRelCurvaCliente').find('th')[numeroDeColunas - 2]).prop('title', 'Total de Vendas do Período Selecionado');
        $($('#tabelaRelCurvaCliente').find('th')[numeroDeColunas - 1]).prop('title', 'Total de Vendas dividido pela Quantidade de Produção');

        $('#tabelaRelCurvaCliente_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelCurvaCliente_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          grid = 1;
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          $.LoadingOverlay('show');
          try {
            const dados = $('#tabelaRelCurvaCliente').DataTable().rows().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório de Curva Cliente', '', '', 999, false, false, dados);
          } catch (error) {
            console.log(error.message);
          } finally {
            $.LoadingOverlay('hide');
          };
        });

        $('#tabelaRelCurvaCliente').DataTable().columns().every(function () {
          if ((colunasInvisiveis.curvaCliente).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });

        $('#tabelaRelCurvaCliente th').on('click', function () {
          listaOrdenacao = adicionaOrdenacao(
            retornaDataSrcColuna($('#tabelaRelCurvaCliente'), $(this)),
            listaOrdenacao
          );
        });

        const tabela_ = $('#tabelaRelCurvaCliente').DataTable().data();

        montaGrafico(tabela_, 'VALORVENDIDO');
        montaGrafico(tabela_, 'QTDEPRODVENDIDO');
        montaGrafico(tabela_, 'QTDEVENDAS');
        await selecionaRegistroTabela();
        if ($('#tabelaRelCurvaCliente').DataTable().rows().count() > 0) {
          $($('#tabelaRelCurvaCliente tbody tr')[0]).trigger('click');
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  function formataTitleHeader(title, somenteMesAno = false) {
    const traducoesCampos = {
      CLIENTE: "Cliente",
      NOME_CLI: "Nome",
      QTDE_VENDAS: "Total Vendas",
      QTDEVENDAS: "Vendas",
      QTDE_PROD_VENDIDO: "Total Produtos",
      QTDEPRODVENDIDO: "Qtde. Prod.",
      VALOR_VENDIDO: "Total Valor",
      VALORVENDIDO: "Valor",
      EMPRESA: "Empresa"
    };

    const traducoesMes = {
      JAN: "Jan.", FEV: "Fev.", MAR: "Mar.", ABR: "Abr.", MAI: "Mai.", JUN: "Jun.",
      JUL: "Jul.", AGO: "Ago.", SET: "Set.", OUT: "Out.", NOV: "Nov.", DEZ: "Dez."
    };

    if (traducoesCampos[title]) {
      return typeof traducoesCampos[title] === 'object'
        ? traducoesCampos[title]
        : traducoesCampos[title];
    }

    const partes = title.split('_');

    if (partes.length < 3) return title;

    const [mes, ano, campo] = partes;
    if (!somenteMesAno)
      return `${traducoesMes[mes] || mes} ${ano} ${traducoesCampos[campo] || traducoesCampos[campo] || campo}`;
    return `${traducoesMes[mes] || mes} ${ano}`;
  };

  async function selecionaRegistroTabela() {
    $('#tabelaRelCurvaCliente tbody').unbind('click');
    $('#tabelaRelCurvaCliente tbody').on('click', 'tr', async function () {
      const tabela = $(this).hasClass('selected') ? $('#tabelaRelCurvaCliente').DataTable().data() : $('#tabelaRelCurvaCliente').DataTable().row($(this)).data();
      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
        montaGrafico(tabela, 'VALORVENDIDO');
        montaGrafico(tabela, 'QTDEPRODVENDIDO');
        montaGrafico(tabela, 'QTDEVENDAS');
        await buscaOrdemProducao();
      } else {
        $('#tabelaRelCurvaCliente').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        montaGrafico(tabela, 'VALORVENDIDO');
        montaGrafico(tabela, 'QTDEPRODVENDIDO');
        montaGrafico(tabela, 'QTDEVENDAS');
        await buscaOrdemProducao($('#tabelaRelCurvaCliente').DataTable().row($(this)).data().CODIGO, `${$('#tabelaRelCurvaCliente').DataTable().row($(this)).data().CODIGO} - ${$('#tabelaRelCurvaCliente').DataTable().row($(this)).data().DESCRICAO}`);
      }
    });
  }

  function montaGrafico(tabela, grafico) {
    const item = !tabela[0] ? tabela : tabela[0];
    const propriedadesIgnoradas = ["CLIENTE", "NOME_CLI", "QTDE_VENDAS", "QTDE_PROD_VENDIDO", "VALOR_VENDIDO", "EMPRESA"];

    const novoObjeto = {};
    let titulo = '';

    if (tabela[0]) {
      for (const propriedade in item) {
        if (!propriedadesIgnoradas.includes(propriedade) && propriedade.substring(9, propriedade.length) === grafico) {
          novoObjeto[propriedade] = 0;
        }
      }

      for (let i = 0; i < tabela.length; i++) {
        const objeto = tabela[i];
        for (const propriedade in objeto) {
          if (!propriedadesIgnoradas.includes(propriedade) && propriedade.substring(9, propriedade.length) === grafico) {
            novoObjeto[propriedade] += !objeto[propriedade] ? 0 : objeto[propriedade];
          }
        }
      }
      titulo = grafico === 'VALORVENDIDO' ? `Valor vendido de todos os clientes`
        : grafico === 'QTDEPRODVENDIDO' ? `Quantidade de produtos vendidos de todos os clientes`
          : grafico === 'QTDEVENDAS' ? `Quantidade de vendas de todos os clientes` : ``;
    } else {
      for (const propriedade in item) {
        if (!propriedadesIgnoradas.includes(propriedade) && propriedade.substring(9, propriedade.length) === grafico) {
          novoObjeto[propriedade] = item[propriedade];
        }
      }
      titulo = grafico === 'VALORVENDIDO' ? `Valor vendido do cliente ${item.CLIENTE} - ${item.NOME_CLI}`
        : grafico === 'QTDEPRODVENDIDO' ? `Quantidade de produtos vendidos do cliente ${item.CLIENTE} - ${item.NOME_CLI}`
          : grafico === 'QTDEVENDAS' ? `Quantidade de vendas do cliente ${item.CLIENTE} - ${item.NOME_CLI}` : ``;
    }

    const dadosFormatados = Object.entries(novoObjeto).map(([name, y]) => ({ name: formataTitleHeader(name, true), y }));
    const containerId = `chart${grafico}`;

    Graficos.criarGrafico({
      container: containerId,
      tipo: 'line',
      dados: dadosFormatados,
      grafico3d: true,
      nomeSerie: 'Valor',
      colunasAgrupamento: ['name'],
      colunasValor: ['y'],
      title: titulo,
      colunasDescricao: [],
      formatarValor: undefined,
      cores: undefined,
      bHorizontal: undefined,
      qtdeRegistros: undefined,
      seriesAgrupadas: undefined,
      ordenacao: undefined,
      colunasSeries: undefined,
      manterOrdemOriginal: true
    });
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))


    $('#tabelaRelCurvaCliente').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.curvaCliente ?? ['EMPRESA'])
  })

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros padrões da tela.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para Imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaRelCurvaCliente',
      popover: {
        title: 'Tabela',
        description: 'Aqui estão os dados dos produtos Filtrados.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});