<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Pedido</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.18.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.18.1" />
  <link rel="shortcut icon" href="favicon.ico">

  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.18.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.2511.18.1" />
  <link rel="stylesheet" type="text/css" href="dist/css/sisplan.newColorsButtons.css?versao=3.2511.18.1" />

  <style>
    #tabelaMaquinaCartao td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaMaquinaCartao td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    #modalPesquisaPedido div {
      z-index: 999 !important;
    }

    #tabelaPedido td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaPedido td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    .thPedido {
      width: 10%;
    }

    .dropdown {
      text-align: left;
    }

    .notfirstchild div:not(:first-child) {
      margin-right: 10px !important;
    }

    #tabelaNotasFiscais_filter {
      visibility: hidden;
      margin: 0px;
      padding: 0px;
      height: 0px;
    }

    .dropdown-item {
      width: 100% !important;
    }

    .table.dataTable tbody td,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }

    .nav-link.disabled {
      pointer-events: none;
      cursor: not-allowed;
      opacity: 0.65;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed zoom-1">
  <div class="wrapper">
    <div class="modal fade" id="modalDuplicarPedido" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Duplicar Pedido</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="flex">
              <div>
                <div class="flex">
                  <div class="group-default form-group col-6">
                    <label for="txtPedidoOrigem">Pedido de Origem</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" aria-describedby="ufError" disabled id="txtPedidoOrigem" name="txtPedidoOrigem" class="form-control" placeholder="Pedido Origem">
                    </div>
                  </div>
                  <div class="group-default form-group col-6">
                    <label for="txtPedidoDestino">Novo Pedido</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" aria-describedby="ufError" id="txtPedidoDestino" name="txtPedidoDestino" class="form-control" placeholder="Novo Pedido">
                    </div>
                  </div>
                </div>
                <div class="col-12" id="ClienteDestino">
                  <label data-error="wrong" data-success="right" for="txtClienteDestino">Cliente: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteDestino" name="txtClienteDestino" class="form-control" placeholder="Cliente Destino">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnClienteDestino" name="btnClienteDestino" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaClienteDestino" name="btnLimpaClienteDestino" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-12" id="StatusDestino">
                  <label data-error="wrong" data-success="right" for="txtStatusDestino">Status: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtStatusDestino" name="txtStatusDestino" class="form-control" placeholder="Status Destino">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnStatusDestino" name="btnStatusDestino" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaStatusDestino" name="btnLimpaStatusDestino" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div>
                <div class="row form-group" style="margin-left: 5%; margin-top: 5%;">
                  <div class="col-lg-6" style="border-right: 1px solid white">
                    <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbColocarFaturadoComoPendente"><label class="labelCheck" for="cbColocarFaturadoComoPendente">Colocar Faturado como Pendente</label></div>
                    <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbNaoDuplicarItensCancelados"><label class="labelCheck" for="cbNaoDuplicarItensCancelados">Não duplicar Itens Cancelados</label></div>
                    <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbColocarCanceladoComoPendente"><label class="labelCheck" for="cbColocarCanceladoComoPendente">Colocar Cancelado como Pendente</label></div>
                    <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbDuplicarSomenteItensPendentes"><label class="labelCheck" for="cbDuplicarSomenteItensPendentes">Duplicar somente itens pendentes</label></div>
                  </div>
                  <div class="col-lg-6">
                    <!-- <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbMenterInfoAdProfDosItens"><label class="labelCheck" for="cbMenterInfoAdProfDosItens">Manter InfoAdProd dos Itens</label></div> -->
                    <!-- <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkCE"><label class="labelCheck" for="checkCE">Não duplicar Fluxo (Pedido4)</label></div> -->
                    <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbDuplicarSomenteItensFaturados"><label class="labelCheck" for="cbDuplicarSomenteItensFaturados">Duplicar somente itens faturados</label></div>
                    <!-- <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkES"><label class="labelCheck" for="checkES">Não duplicar Agendamento (Pedido4)</label></div> -->
                    <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbDuplicarQuantidadeOriginalPedido"><label class="labelCheck" for="cbDuplicarQuantidadeOriginalPedido">Duplicar quantidade original do pedido</label></div>
                    <div class="icheck-primary"><input type="checkbox" class="configCheck" id="cbIgnorarProdutosSemSaldo"><label class="labelCheck" for="cbIgnorarProdutosSemSaldo">Ignorar Produtos sem Saldo</label></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
            <button type="button" id="btnDuplicarPedido" class="btn btn-primary">Duplicar</button>
          </div>
        </div>
      </div>
    </div>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Pedido</h1>
              <button class="btnTutorial" id="tutorial" style="color: rgb(255, 255, 255);">
                <i class="fas fa-question-circle"></i>
              </button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid" id="divTabelaPedido">
          <div class="row card">
            <div class="col-12 d-flex justify-content-between" style="margin-top: 16px; padding-left: 20px; padding-right: 20px;">
              <div class="d-flex align-items-center" style="z-index:9999 !important">
                <button class="btn btn-sisp btnFiltros" id="btnFiltros"><span class="fas fa-filter"></span> Filtros</button>
                <button class="btn btn-sisp btn-danger marginBtnH" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
                <button class="btn btn-sisp btn-secondary marginBtnH" id="btnImprimir" title="Este botão chama o Layout RelPedidoA.FR3"><i class="fas fa-print"></i> Imprimir</button>
              </div>
            </div>
            <div class="row">
              <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                <div id="graficosPedidos" class="mt-5" style="width: 100%;"></div>
              </div>
              <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                <div id="graficosPedidos1" class="mt-5" style="width: 100%;"></div>
              </div>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de pedidos</h5>
              <table id="tabelaPedido" class="table table-sm-sisp table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm thPedido">Pedido</th>
                    <th class="th-sm">Cliente</th>
                    <th class="th-sm">Financeiro</th>
                    <th class="th-sm">Comercial</th>
                    <th class="th-sm">Representante</th>
                    <th class="th-sm">Transportadora</th>
                    <th class="th-sm">Valor Liq.</th>
                    <th class="th-sm">Data Emissão</th>
                    <th class="th-sm">Data Entrega</th>
                    <th class="th-sm">Ped. Cliente</th>
                    <th class="th-sm">Situacão</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>

          <div class="row card p-3">
            <div class="col-12 row mt-3">
              <div class="table-responsive col-sm-6 col-12">
                <h5>Itens</h5>
                <table id="tabelaPedidoVisualizacao" class="table table-sm-sisp table-select table-hover" width="100%">
                  <thead></thead>
                  <tbody></tbody>
                </table>
              </div>
              <div class="table-responsive col-sm-6 col-12">
                <h5>Notas</h5>
                <table id="tabelaPedidoNotasVisualizacao" class="table table-sm-sisp table-select table-hover" width="100%">
                  <thead></thead>
                  <tbody></tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row" style="margin-top: 1.4%;">
                <div class="group-default form-group col-3">
                  <label for="txtDataEmiDe">Data Cadastro De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEmiDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEntregaDe">Data Entrega De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEntregaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataFaturaDe">Data Fatura De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataFaturaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataSaidaDe">Data Saída De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataSaidaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEmiAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEmiAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEntregaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEntregaAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataFaturaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataFaturaAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataSaidaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataSaidaAte" name="DataAte">
                  </div>
                </div>
              </div>

              <div class="row">

                <div class="col-lg-9">
                  <div id="PedidoConsulta">
                    <label data-error="wrong" data-success="right" for="txtPedidoConsulta">Pedido </label>
                    <div class="input-group">
                      <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtPedidoConsulta" name="txtPedidoConsulta" class="form-control" placeholder="Cliente"> -->
                      <select class="js-example-programmatic js-states form-control" id="txtPedidoConsulta" name="txtPedidoConsulta" multiple="multiple">
                      </select>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnPedidoConsulta" name="btnPedidoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaPedidoConsulta" name="btnLimpaPedidoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <!-- <label data-error="wrong" data-success="right" for="txtPedidoConsulta">Pedido </label>
                  <div class="input-group col-12" style="padding-left: 0px;">
                    <input type="text" class="input-default col-lg-2 col-12 focus form-control" id="txtPedidoConsulta" name="txtPedidoConsulta" class="form-control" placeholder="Pedido">
                    <button class="btn bg-danger" id="btn-PedidoConsulta" name="btn-PedidoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <input type="text" id="txtListaPedidos" class="form-group col-lg-12 col-12 input-default focus form-control" placeholder="Lista de Pedidos" disabled>
                    <button class="btn bg-danger" id="btn-limpa-PedidoConsulta" name="btn-limpa-PedidoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div> -->
                </div>

                <div class="col-lg-3 pl-5 pt-4">
                  <button class="btn btn-danger btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>   
                </div>

              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="ClienteConsulta">
                  <label data-error="wrong" data-success="right" for="txtClienteConsulta">Cliente </label>
                  <div class="input-group">
                    <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteConsulta" name="txtClienteConsulta" class="form-control" placeholder="Cliente"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtClienteConsulta" name="txtClienteConsulta" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnClienteConsulta" name="btnClienteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaClienteConsulta" name="btnLimpaClienteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="RepresentanteConsulta">
                  <label data-error="wrong" data-success="right" for="txtRepresentanteConsulta">Representante </label>
                  <div class="input-group">
                    <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtRepresentanteConsulta" name="txtRepresentanteConsulta" class="form-control" placeholder="Representante"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtRepresentanteConsulta" name="txtRepresentanteConsulta" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnRepresentanteConsulta" name="btnRepresentanteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaRepresentanteConsulta" name="btnLimpaRepresentanteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="StatusConsulta">
                  <label data-error="wrong" data-success="right" for="txtStatusConsulta">Status </label>
                  <div class="input-group">
                    <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtStatusConsulta" name="txtStatusConsulta" class="form-control" placeholder="Status"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtStatusConsulta" name="txtStatusConsulta" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnStatusConsulta" name="btnStatusConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaStatusConsulta" name="btnLimpaStatusConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="TabPrecoConsulta">
                  <label data-error="wrong" data-success="right" for="txtTabPrecoConsulta">Tabela de Preço </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTabPrecoConsulta" name="txtTabPrecoConsulta" class="form-control" placeholder="Tabela de preço">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TabPrecoConsulta" name="btn-TabPrecoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TabPrecoConsulta" name="btn-limpa-TabPrecoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="ColecaoConsulta">
                  <label data-error="wrong" data-success="right" for="txtColecaoConsulta">Coleção </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtColecaoConsulta" name="txtColecaoConsulta" class="form-control" placeholder="Coleção">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ColecaoConsulta" name="btn-ColecaoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ColecaoConsulta" name="btn-limpa-ColecaoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="GrupoPedConsulta">
                  <label data-error="wrong" data-success="right" for="txtGrupoPedConsulta">Grupo Pedido </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoPedConsulta" name="txtGrupoPedConsulta" class="form-control" placeholder="Grupo pedido">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoPedConsulta" name="btn-GrupoPedConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoPedConsulta" name="btn-limpa-GrupoPedConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>

              <div class="row" style="margin-top: 1.4%;">

                <div class="col-4" id="GrupoProdConsulta">
                  <label data-error="wrong" data-success="right" for="txtGrupoProdConsulta">Grupo Produto </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoProdConsulta" name="txtGrupoProdConsulta" class="form-control" placeholder="Grupo produto">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoProdConsulta" name="btn-GrupoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoProdConsulta" name="btn-limpa-GrupoProdConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="TipoProdConsulta">
                  <label data-error="wrong" data-success="right" for="txtTipoProdConsulta">Tipo Produto </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTipoProdConsulta" name="txtTipoProdConsulta" class="form-control" placeholder="Tipo produto">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TipoProdConsulta" name="btn-TipoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TipoProdConsulta" name="btn-limpa-TipoProdConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="UFConsulta">
                  <label data-error="wrong" data-success="right" for="txtUFConsulta">UF </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtUFConsulta" name="txtUFConsulta" class="form-control" placeholder="UF">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-UFConsulta" name="btn-UFConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-UFConsulta" name="btn-limpa-UFConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="ResponsavelConsulta">
                  <label data-error="wrong" data-success="right" for="txtResponsavelConsulta">Responsável </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtResponsavelConsulta" name="txtResponsavelConsulta" class="form-control" placeholder="Responsável">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ResponsavelConsulta" name="btn-ResponsavelConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ResponsavelConsulta" name="btn-limpa-ResponsavelConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="TipoVendaConsulta">
                  <label data-error="wrong" data-success="right" for="txtTipoVendaConsulta">Tipo Venda </label>
                  <div class="input-group">
                    <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTipoVendaConsulta" name="txtTipoVendaConsulta" class="form-control" placeholder="TipoVenda"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtTipoVendaConsulta" name="txtTipoVendaConsulta" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTipoVendaConsulta" name="btnTipoVendaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTipoVendaConsulta" name="btnLimpaTipoVendaConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row" style="margin-top: 1%;">
                <div class="group-default form-group col-4">
                  <label for="">Financeiro: </label>
                  <div class="relative">
                    <select name="" id="txtBloqFinConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="1">Liberados</option>
                      <option value="0">Bloqueados</option>
                    </select>
                  </div>
                </div>
                <div class="group-default form-group col-4">
                  <label for="">Comercial: </label>
                  <div class="relative">
                    <select name="" id="txtBloqComConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="1">Liberados</option>
                      <option value="0">Bloqueados</option>
                    </select>
                  </div>
                </div>

                <div class="group-default form-group col-4">
                  <label for="">Situação: </label>
                  <div class="relative">
                    <select name="" id="txtSituacaoConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="P">Pendentes</option>
                      <option value="F">Faturados</option>
                    </select>
                  </div>
                </div>
              </div>
            </div>

            <!-- <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div> -->
            <div class="modal-footer justify-content-start pl-0">
              <div class="row col-12">
                <div class="col-md-4 col-6">
                  <label for="txtOrdem">Ordem Impressão:</label>
                  <div class="relative d-flex align-items-center">
                    <select id="txtOrdem" class="input-default focus custom-select">
                    </select>
                    <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                      <i class="fas fa-check"></i>
                    </button>
                  </div>
                </div>
                <div class="col-md-8 col-6 d-flex justify-content-end align-items-end pr-2">
                  <div class="d-flex">
                    <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                      <span class="fas fa-search"></span> Consultar
                    </button>
                    <button class="btn btn-danger btn-sisp marginBtnH" id="btnLimparFiltros">
                      <span class="fas fa-trash"></span> Limpar Filtros
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div id="modalAntecipacao" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Antecipação</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="row">

                <div class="col-2">
                  <label data-error="wrong" data-success="right" for="txtPedidoAnte">Pedido </label>
                  <div class="input-group">
                    <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtPedidoAnte" name="txtPedidoAnte" class="form-control" placeholder="Pedido">
                  </div>
                </div>

                <div class="col-5">
                  <label data-error="wrong" data-success="right" for="txtClienteAnte">Cliente </label>
                  <div class="input-group">
                    <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteAnte" name="txtClienteAnte" class="form-control" placeholder="Cliente">
                  </div>
                </div>

                <div class="col-5">
                  <label data-error="wrong" data-success="right" for="txtRepresenAnte">Representante </label>
                  <div class="input-group">
                    <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtRepresenAnte" name="txtRepresenAnte" class="form-control" placeholder="Representante">
                  </div>
                </div>

              </div>
              <div class="row" style="margin-top: 1.2%;" style="margin-top: 1.2%;">

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtMoeda">Moeda *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Moeda" name="btn-Moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Moeda" name="btn-limpa-Moeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtHistorico">Histórico *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Histórico">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Historico" name="btn-limpa-Historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtClasseGer">Classe Gerencial *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" class="form-control" placeholder="Classe Gerencial">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ClasseGer" name="btn-ClasseGer" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ClasseGer" name="btn-limpa-ClasseGer" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>
              <div class="row" style="margin-top: 1.2%;">

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtSituacao">Situação *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Situação">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Situacao" name="btn-Situacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Situacao" name="btn-limpa-Situacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtConta">Conta *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Conta" name="btn-Conta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Conta" name="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtBanco">Banco *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Banco" name="btn-Banco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Banco" name="btn-limpa-Banco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>
              <div class="row" style="margin-top: 1.2%;">

                <div class="col-sm-2">
                  <label>Emissão *</label>
                  <div class="relative" id="DataEmissao">
                    <input type="date" max="2500-12-31" autocomplete="off" class="input-default focus form-control validatel" id="txtDTemissao" name="txtDTemissao">
                  </div>
                </div>

                <div class="col-sm-2">
                  <label>Vencimento *</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" autocomplete="off" class="input-default focus form-control validate" id="txtDTvencimento" name="txtDTvencimento">
                  </div>
                </div>

                <div class="col-sm-4">
                  <label data-error="wrong" data-success="right" for="txtCaixa">Caixa *</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCaixa" name="txtCaixa" class="form-control" placeholder="Caixa">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-caixa" name="btn-caixa-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-caixa2" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtValor">Valor *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtValor" name="txtValor" class="form-control" placeholder="Valor">
                  </div>
                </div>


              </div>

              <div class="row d-flex justify-content-end" style="margin-top: 1.2%;">
                <div class="col-4">
                  <label for="txtStatus">Status</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtStatus" name="txtStatus" placeholder="Status">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Status" name="btn-Status" data-button="absolute" type="button"> <i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Status" type="button"> <i class="m-0 p-0 fas fa-trash"></i> </button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row d-flex justify-content-end" style="margin-top: 1.2%;">
                <div id="LancaCC" class="col-4 d-flex align-items-center">
                  <input type="checkbox" id="cbNaoLancaCc" style="width: 20px; height: 20px; margin-right: 10px;" class="d-none">
                  <label for="cbNaoLancaCc" id="labelNaoLancaCc" style="margin-bottom: 0rem!important;" class="d-none">
                    Não lançar conta corrente
                  </label>
                </div>
              </div>

              <div class="d-none" id="cartao" style="margin-top: 1.2%;"><label data-error="wrong" data-success="right" for="txtNSU" style="font-size: 20px; margin-left: -6px;">Dados cartão</label>
                <div class="form-row">
                  <div class="col-md-3 col-12 px-0">
                    <label data-error="wrong" data-success="right" for="txtNSU">NSU</label>
                    <div class="input-group">
                      <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNSU" name="txtNSU" class="form-control" placeholder="NSU">
                    </div>
                  </div>

                  <div class="col-md-3 col-12">
                    <label for="select_bandeira">Bandeira</label>
                    <div class="input-group">
                      <select class="form-control select2 select2-danger focus" id="select_bandeira" name="select_bandeira" data-dropdown-css-class="select2-danger" style="width: 100%;">
                        <option value="" selected="selected">Selecione uma bandeira</option>
                      </select>
                    </div>
                  </div>

                  <div class="col-md-3 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtCondicaoDePagamento">Cond. Pagamento</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCondicaoDePagamento" name="txtCondicaoDePagamento" placeholder="Condição de Pagamento">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-CondicaoDePagamento" name="btn-CondicaoDePagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-condicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>

                  <div class="col-md-3 col-12">
                    <div class="group-default">
                      <label for="txtNrParcelas">Nr. Parcelas</label>
                      <div class="relative">
                        <input type="text" placeholder="Nr. Parcelas" class="input-default" id="txtNrParcelas" value="1" name="txtNrParcelas" readonly>
                      </div>
                    </div>
                  </div>

                </div>
              </div>


            </div>

            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-danger btn-sisp" id="btnConfirmarAnte">Confirmar</button>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" tabindex="-1" role="dialog" id="modal-situacaopedido">
        <div class="modal-dialog modal-md modal-dialog-centered" style="max-width: 840px" id="tammodal">
          <div class="modal-content" id="modal-content-situacaopedido">
            <div class="modal-header">
              <h4 class="modal-title">Situação do Pedido - [<span id="txtTituloSituacao"></span>]</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body mt-1">
              <div class="form-row flex notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 mr-1">
                  <label data-error="wrong" data-success="right" id="lblQtde" for="lblVazio"></label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <label data-error="wrong" data-success="right" id="lblQtde" for="lblQtde">Qtde</label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <label data-error="wrong" data-success="right" for="lblValor">Valor</label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <label data-error="wrong" data-success="right" for="lblVlrLiquido">Valor Líquido</label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <label data-error="wrong" data-success="right" for="lblPesoMedio">Peso Médio Somado</label>
                </div>
              </div>
              <div class="form-row flex notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblQtdeTotal" for="lblQtdeTotal">Qtde Total: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtQtdeTotalQtde" name="txtQtdeTotalQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtQtdeTotalValor" name="txtQtdeTotalValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtQtdeTotalValorLiq" name="txtQtdeTotalValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtQtdeTotalPesoMedioSomado" name="txtQtdeTotalPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblQtdeTotal" for="lblQtdeTotal">Qtde Total + Frete: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtQtdeTotalFreteQtde" name="txtQtdeTotalFreteQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtQtdeTotalFreteValor" name="txtQtdeTotalFreteValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtQtdeTotalFreteValorLiq" name="txtQtdeTotalFreteValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtQtdeTotalFretePesoMedioSomado" name="txtQtdeTotalFretePesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblFaturado" for="lblFaturado">Faturado: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtFaturadoQtde" name="txtFaturadoQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtFaturadoValor" name="txtFaturadoValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtFaturadoValorLiq" name="txtFaturadoValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtFaturadoPesoMedioSomado" name="txtFaturadoPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblReserva" for="lblReserva">Reserva: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtReservaQtde" name="txtReservaQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtReservaValor" name="txtReservaValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtReservaValorLiq" name="txtReservaValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtReservaPesoMedioSomado" name="txtReservaPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblExpedicao" for="lblExpedicao">Expedição: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtExpedicaoQtde" name="txtExpedicaoQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtExpedicaoValor" name="txtExpedicaoValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtExpedicaoValorLiq" name="txtExpedicaoValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtExpedicaoPesoMedioSomado" name="txtExpedicaoPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblCancelado" for="lblCancelado">Cancelado: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtCanceladoQtde" name="txtCanceladoQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtCanceladoValor" name="txtCanceladoValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtCanceladoValorLiq" name="txtCanceladoValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtCanceladoPesoMedioSomado" name="txtCanceladoPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblSaldoPedido" for="lblSaldoPedido">Saldo Pedido - Exp: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoPedidoQtde" name="txtSaldoPedidoQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoPedidoValor" name="txtSaldoPedidoValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoPedidoValorLiq" name="txtSaldoPedidoValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtSaldoPedidoPesoMedioSomado" name="txtSaldoPedidoPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblSaldoPedidoExp" for="lblSaldoPedidoExp">Saldo Pedido + Exp: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoPedidoExpQtde" name="txtSaldoPedidoExpQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoPedidoExpValor" name="txtSaldoPedidoExpValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoPedidoExpValorLiq" name="txtSaldoPedidoExpValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtSaldoPedidoExpPesoMedioSomado" name="txtSaldoPedidoExpPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-4 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblFaturadoNota" for="lblFaturadoNota">Faturado Nota: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtFaturadoNotaQtde" name="txtFaturadoNotaQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtFaturadoNotaValor" name="txtFaturadoNotaValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtFaturadoNotaValorLiq" name="txtFaturadoNotaValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtFaturadoNotaPesoMedioSomado" name="txtFaturadoNotaPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblDevolvidoNota" for="lblDevolvidoNota">Devolvido Nota: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtDevolvidoNotaQtde" name="txtDevolvidoNotaQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtDevolvidoNotaValor" name="txtDevolvidoNotaValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtDevolvidoNotaValorLiq" name="txtDevolvidoNotaValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtDevolvidoNotaPesoMedioSomado" name="txtDevolvidoNotaPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblCanceladoNota" for="lblCanceladoNota">Cancelado Nota: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtCanceladoNotaQtde" name="txtCanceladoNotaQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtCanceladoNotaValor" name="txtCanceladoNotaValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtCanceladoNotaValorLiq" name="txtCanceladoNotaValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtCanceladoNotaPesoMedioSomado" name="txtCanceladoNotaPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblSaldoNota" for="lblSaldoNota">Saldo Nota: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoNotaQtde" name="txtSaldoNotaQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoNotaValor" name="txtSaldoNotaValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtSaldoNotaValorLiq" name="txtSaldoNotaValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtSaldoNotaPesoMedioSomado" name="txtSaldoNotaPesoMedioSomado" readonly>
                </div>
              </div>
              <div class="form-row flex mt-1 notfirstchild">
                <div class="col-md-3 col-sm-3 col-3 px-0 text-right mt-2 mr-1" style="white-space: nowrap">
                  <label data-error="wrong" data-success="right" id="lblTotalIPI" for="lblTotalIPI">Total IPI/Total com IPI: </label>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtTotalIPIQtde" name="txtTotalIPIQtde" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtTotalIPIValor" name="txtTotalIPIValor" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default" id="txtTotalIPIValorLiq" name="txtTotalIPIValorLiq" readonly>
                </div>
                <div class="col-md-2 col-sm-2 col-2 px-0 text-right">
                  <input type="text" class="input-default d-none" id="txtTotalIPIPesoMedioSomado" name="txtTotalIPIPesoMedioSomado" readonly>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" tabindex="-1" role="dialog" id="modal-notasFiscais">
        <div class="modal-dialog modal-md modal-dialog-centered" style="max-width: 840px" id="tammodal">
          <div class="modal-content" id="modal-content-notasFiscais">
            <div class="modal-header">
              <h4 class="modal-title">Notas Fiscais do Pedido - [<span id="txtTituloNotasFiscais"></span>]</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="col-sm-12 table-responsive card-body pl-0 pt-0">
                <table id="tabelaNotasFiscais" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%">
                  <thead>
                    <tr>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" tabindex="-1" role="dialog" id="modal-enderecos">
        <div class="modal-dialog modal-md modal-dialog-centered" style="max-width: 840px" id="endModal">
          <div class="modal-content" id="modal-content-enderecos" style="max-height: 95vh !important">
            <div class="modal-header">
              <h4 class="modal-title">Endereços do pedido - [<span id="txtTituloEnderecos"></span>]</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>

            <nav>
              <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none;">
                <a class="nav-link abaLink active" id="tabPedido" data-toggle="tab" href="#divPedido" role="tab" aria-controls="divPedido" aria-selected="true">Pedido</a>
                <a class="nav-link abaLink" id="tabInfCliEnt" data-toggle="tab" href="#divInfCliEnt" role="tab" aria-controls="divInfCliEnt" aria-selected="false">Inf. Cli. Ent.</a>
              </div>
            </nav>

            <div class="card-body p-0" style="height: auto;">
              <div class="card">
                <div class="tab-content" id="nav-tabContent">

                  <div class="tab-pane fade show active" id="divPedido" role="tabpanel" aria-labelledby="tabPedido">
                    <div class="modal-body" style="min-height: 75vh; height: 75vh;">

                      <div class="mb-2">
                        <fieldset class="form border-Field mb-1">
                          <legend class="textoBorda pb-0 mb-0">Endereço da Entidade</legend>

                          <div class="form-row flex pb-3">
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtEntidadeEndereco">Endereço:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntidadeEndereco" name="txtEntidadeEndereco" class="form-control" placeholder="Endereço" disabled>
                              </div>
                            </div>
                            <div class="col-2">
                              <label data-error="wrong" data-success="right" for="txtEntidadeNumero">Número:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntidadeNumero" name="txtEntidadeNumero" class="form-control" placeholder="Número" disabled>
                              </div>
                            </div>
                            <div class="col-4">
                              <label data-error="wrong" data-success="right" for="txtEntidadeBairro">Bairro:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntidadeBairro" name="txtEntidadeBairro" class="form-control" placeholder="Bairro" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtEntidadeComplemento">Complemento:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntidadeComplemento" name="txtEntidadeComplemento" class="form-control" placeholder="Complemento" disabled>
                              </div>
                            </div>
                            <div class="col-2">
                              <label data-error="wrong" data-success="right" for="txtEntidadeCep">Cep:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntidadeCep" name="txtEntidadeCep" class="form-control" placeholder="Cep" disabled>
                              </div>
                            </div>
                            <div class="col-4">
                              <label data-error="wrong" data-success="right" for="txtEntidadeCidade">Cidade/Estado:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntidadeCidade" name="txtEntidadeCidade" class="form-control" placeholder="Cidade/Estado" disabled>
                              </div>
                            </div>
                          </div>

                        </fieldset>
                      </div>
                      <div class="mb-2">
                        <fieldset class="form border-Field">
                          <legend class="textoBorda pb-0 mb-0">Endereço de Entrega</legend>

                          <div class="form-row flex pb-3">
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtEntregaEndereco">Endereço:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntregaEndereco" name="txtEntregaEndereco" class="form-control" placeholder="Endereço" disabled>
                              </div>
                            </div>
                            <div class="col-2">
                              <label data-error="wrong" data-success="right" for="txtEntregaNumero">Número:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntregaNumero" name="txtEntregaNumero" class="form-control" placeholder="Número" disabled>
                              </div>
                            </div>
                            <div class="col-4">
                              <label data-error="wrong" data-success="right" for="txtEntregaBairro">Bairro:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntregaBairro" name="txtEntregaBairro" class="form-control" placeholder="Bairro" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtEntregaComplemento">Complemento:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntregaComplemento" name="txtEntregaComplemento" class="form-control" placeholder="Complemento" disabled>
                              </div>
                            </div>
                            <div class="col-2">
                              <label data-error="wrong" data-success="right" for="txtEntregaCep">Cep:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntregaCep" name="txtEntregaCep" class="form-control" placeholder="Cep" disabled>
                              </div>
                            </div>
                            <div class="col-4">
                              <label data-error="wrong" data-success="right" for="txtEntregaCidade">Cidade/Estado:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntregaCidade" name="txtEntregaCidade" class="form-control" placeholder="Cidade/Estado" disabled>
                              </div>
                            </div>
                          </div>

                        </fieldset>
                      </div>
                      <div class="mb-2">
                        <fieldset class="form border-Field">
                          <legend class="textoBorda pb-0 mb-0">Endereço de Cobranca</legend>

                          <div class="form-row flex pb-3">
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtCobrancaEndereco">Endereço:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCobrancaEndereco" name="txtCobrancaEndereco" class="form-control" placeholder="Endereço" disabled>
                              </div>
                            </div>
                            <div class="col-2">
                              <label data-error="wrong" data-success="right" for="txtCobrancaNumero">Número:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCobrancaNumero" name="txtCobrancaNumero" class="form-control" placeholder="Número" disabled>
                              </div>
                            </div>
                            <div class="col-4">
                              <label data-error="wrong" data-success="right" for="txtCobrancaBairro">Bairro:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCobrancaBairro" name="txtCobrancaBairro" class="form-control" placeholder="Bairro" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtEntregaComplemento">Complemento:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtEntregaComplemento" name="txtEntregaComplemento" class="form-control" placeholder="Complemento" disabled>
                              </div>
                            </div>
                            <div class="col-2">
                              <label data-error="wrong" data-success="right" for="txtCobrancaCep">Cep:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCobrancaCep" name="txtCobrancaCep" class="form-control" placeholder="Cep" disabled>
                              </div>
                            </div>
                            <div class="col-4">
                              <label data-error="wrong" data-success="right" for="txtCobrancaCidade">Cidade/Estado:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCobrancaCidade" name="txtCobrancaCidade" class="form-control" placeholder="Cidade/Estado" disabled>
                              </div>
                            </div>
                          </div>

                        </fieldset>
                      </div>
                      <div class="mb-2">
                        <fieldset class="form border-Field">
                          <legend class="textoBorda pb-0 mb-0">Endereço Personalizado</legend>

                          <div class="form-row flex pb-3">
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoEndereco">Endereço:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control inputEnderecoPerso" id="txtPersonalizadoEndereco" name="txtPersonalizadoEndereco" class="form-control" placeholder="Endereço" disabled>
                              </div>
                            </div>
                            <div class="col-2">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoNumero">Número:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control inputEnderecoPerso" id="txtPersonalizadoNumero" name="txtPersonalizadoNumero" class="form-control" placeholder="Número" disabled>
                              </div>
                            </div>
                            <div class="col-4">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoBairro">Bairro:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control inputEnderecoPerso" id="txtPersonalizadoBairro" name="txtPersonalizadoBairro" class="form-control" placeholder="Bairro" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoCep">Cep:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate inputEnderecoPerso" disabled id="txtPersonalizadoCep" name="txtPersonalizadoCep" required>
                                <div class="input-group-append">
                                  <button class="btn bg-danger inputEnderecoPerso" disabled id="btnPersonalizadoCep" name="btnPersonalizadoCep" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger inputEnderecoPerso" disabled id="btnLimpaPersonalizadoCep" name="btnLimpaPersonalizadoCep" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoCidade">Cidade/Estado:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtPersonalizadoCidade" name="txtPersonalizadoCidade" class="form-control" placeholder="Cidade/Estado" disabled>
                              </div>
                            </div>
                            <div class="col-12">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoComplemento">Complemento:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control inputEnderecoPerso" id="txtPersonalizadoComplemento" name="txtPersonalizadoComplemento" class="form-control" placeholder="Complemento" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoDDDFone">DDD+Fone:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control inputEnderecoPerso" id="txtPersonalizadoDDDFone" name="txtPersonalizadoDDDFone" class="form-control" placeholder="(99) 99999-9999" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtPersonalizadoRecebedor">Recebedor:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control inputEnderecoPerso" id="txtPersonalizadoRecebedor" name="txtPersonalizadoRecebedor" class="form-control" placeholder="Recebedor" disabled>
                              </div>
                            </div>
                          </div>
                        </fieldset>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="divInfCliEnt" role="tabpanel" aria-labelledby="tabInfCliEnt">
                    <div class="modal-body" style="min-height: 75vh; height: 75vh;">
                      <div class="col-12 px-0 mb-2">
                        <label data-error="wrong" data-success="right" for="txtInfCliEnt">Cliente Entrega:</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control validate inputInfCliEnt" disabled id="txtInfCliEnt" name="txtInfCliEnt" required>
                          <input type="text" class="input-default focus form-control validate infoCliEntOrig d-none" disabled id="txtInfCliEntOrig" name="txtInfCliEntOrig">
                          <div class="input-group-append">
                            <button class="btn bg-danger inputInfCliEnt" disabled id="btnInfCliEnt" name="btnInfCliEnt" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger inputInfCliEnt" disabled id="btnLimpaInfCliEnt" name="btnLimpaInfCliEnt" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                      <div class="mb-2">
                        <fieldset class="form border-Field">
                          <legend class="textoBorda pb-0 mb-0">Informações do Cliente de Entrega</legend>

                          <div class="form-row flex pb-3">
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntCadastro">Cadastro:</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtInfCliEntCadastro" name="DataDe" placeholder="Cadastro" disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntFundacao">Fundação:</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtInfCliEntFundacao" name="DataDe" placeholder="Fundação" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntEmail">Email:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntEmail" name="txtInfCliEntEmail" class="form-control" placeholder="Email" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntFantasia">Fantasia:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntFantasia" name="txtInfCliEntFantasia" class="form-control" placeholder="Fantasia" disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntCNPJ">CNPJ:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntCNPJ" name="txtInfCliEntCNPJ" class="form-control" placeholder="CNPJ" disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntInscricao">Inscrição Estadual:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntInscricao" name="txtInfCliEntInscricao" class="form-control" placeholder="Inscrição Estadual" disabled>
                              </div>
                            </div>
                            <div class="col-6">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntEndereco">Endereço:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntEndereco" name="txtInfCliEntEndereco" class="form-control" placeholder="Endereço" disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntCEP">CEP:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntCEP" name="txtInfCliEntCEP" class="form-control" placeholder="CEP" disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntCidade">Cidade/Estado:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntCidade" name="txtInfCliEntCidade" class="form-control" placeholder="Cidade/Estado" disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntSintegra">Sintegra:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntSintegra" name="txtInfCliEntSintegra" class="form-control" placeholder="Sintegra" disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntRamoAtiv">Ramo Ativ.:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntRamoAtiv" name="txtInfCliEntRamoAtiv" class="form-control" placeholder="Ramo Ativ." disabled>
                              </div>
                            </div>
                            <div class="col-3">
                              <label data-error="wrong" data-success="right" for="txtInfCliEntTelefone">Telefone:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtInfCliEntTelefone" name="txtInfCliEntTelefone" class="form-control" placeholder="Telefone" disabled>
                              </div>
                            </div>
                            <div class="col-3 mt-4">
                              <div class="icheck-primary">
                                <input type="checkbox" class="configCheck" id="cbInfCliEntAtivo" disabled>
                                <label class="labelCheck" for="cbInfCliEntAtivo">Ativo</label>
                              </div>
                            </div>
                        </fieldset>
                      </div>
                    </div>
                  </div>

                </div>

              </div>
            </div>

            <div class="modal-footer">
              <div class="row" id="containerEditarEndereco">
                <button type="button" id="btnAlterarEndereco" class="btn btn-primary mr-2">Alterar</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
              </div>
              <div class="row d-none" id="containerCancelarEdicaoEndereco">
                <button type="button" id="btnConfirmarEndereco" class="btn btn-primary btnVerde mr-2">Confirmar</button>
                <button type="button" id="btnDesistirEndereco" class="btn btn-secondary">Desistir</button>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>

  </div>
  </div>
  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.18.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.18.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2511.18.1"></script>
  <script src="utils/funcoes.js?versao=3.2511.18.1"></script>
  <script src="utils/cookies.js?versao=3.2511.18.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2511.18.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2511.18.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.2511.18.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/jquery.mask.min.js?versao=3.2511.18.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2511.18.1"></script>
  <script src="graficos/graficos.js?versao=3.2511.18.1"></script>
  <script src="plugins/high-charts/highcharts.js"></script>
  <script src="plugins/high-charts/highcharts-3d.js"></script>
  <script src="plugins/high-charts/cylinder.js"></script>
  <script src="plugins/high-charts/exporting.js"></script>
  <script src="plugins/high-charts/export-data.js"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('PEDIDO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/pedido/acesso_pedido/acesso_pedido.js?versao=3.2511.18.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>