$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#formPrincipal",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: "#formAprovador",
        popover: {
          title: "Aprovadores",
          description:
            "Aqui se encontram os aprovadores do fluxo.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui se encontra o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui se encontra o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const url = window.location.href
  const id = url.split('/')[url.split('/').length - 1]

  if (id && id !== 'create') {
    const params = new URLSearchParams(id);

    const produto = params.get("PRODUTO");
    const numero = params.get("NUMERO");
    $('#txtProduto').prop('disabled', true)
    $('#btnProduto').prop('disabled', true)
    $('#btnLimpaProduto').prop('disabled', true)
    carregarCadastro({ produto, numero })
  } else {
    criarTabelaGrade({ data: [], columns: [] })
  }

  $('.campoFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  componenteFiltro('produto', false, false)

  async function buscarDados({ produto, numero }) {
    const response = await requisicao('GET', `/sisplan/formacao_kit/v1/kit?`, `&DADOS=${encodeURIComponent(JSON.stringify({ produto, numero }))}`, '', 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function carregarCadastro({ produto, numero }) {
    try {
      buscarDados({ produto, numero }).then((dados) => {
        const { kit, tamanhos } = dados
        if (!kit) {
          return
        }
        preencherDadosCapa({
          numero: kit.numero,
          descKit: kit.descKit,
          ativo: kit.ativo,
          descricao: kit.descricao,
          produto: kit.produto,
        })
        const data = transformarDadosTabelaGrade(kit.grade, tamanhos)
        const columns = retornarColunasTabelaGrade(tamanhos)
        criarTabelaGrade({ data, columns, })
      })
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar o cadastro.')
    }
  }

  function transformarDadosTabelaGrade(grade, tamanhos) {
    try {
      const data = []

      grade.forEach((cor) => {
        const datatableItem = {
          cor: cor.codigo,
          descCor: cor.descricao,
        }
        tamanhos.forEach((tamFaixa) => {
          const qtde = cor.tamanhos?.find((it) => it.codigo === tamFaixa)?.qtde ?? 0
          datatableItem[tamFaixa] = retornarInputQtde(qtde, cor.codigo, tamFaixa)
        })
        data.push(datatableItem)
      })

      return data
    } catch (error) {
      console.error(error)
      return []
    }
  }

  function retornarColunasTabelaGrade(tamanhos) {
    try {
      const columns = [
        {
          title: 'Cor',
          data: 'cor',
        },
        {
          title: 'Desc. Cor',
          data: 'descCor',
        }
      ]

      tamanhos.forEach((tam) => {
        columns.push({
          title: tam,
          data: tam,
        })
      })

      return columns
    } catch (error) {
      console.error(error)
      return []
    }
  }

  function preencherDadosCapa({
    numero,
    descKit,
    ativo,
    produto,
    descricao,
  }) {
    $('#txtNumero').val(numero)
    $('#txtDescricao').val(descKit)
    $('#cbKitAtivo').prop('checked', ativo)
    insereValor('#txtProduto', produto, descricao)
  }

  function criarTabelaGrade({ data, columns }) {
    if ($.fn.DataTable.isDataTable('#tabelaGrade')) {
      $('#tabelaGrade').DataTable().destroy()
      $('#tabelaGrade').empty()
    }

    $('#tabelaGrade').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '150px',
    })
    setTimeout(() => {
      $('#tabelaAprovadores').DataTable().columns.adjust().draw(false)
    }, 300)

    adicionarFormatacaoCampos()
  }

  $('#txtProduto').on('blur', function () {
    if (!this.value) {
      return
    }

    carregarGradeProduto(pegaChave(this.value))
  })

  async function carregarGradeProduto(codigo) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('GET', `/sisplan/formacao_kit/v1/produto?`, `&CODIGO=${encodeURIComponent(codigo)}`, '', 3600000)
      const json = await response.json()

      if (!json) {
        return
      }

      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      const { grade, tamanhos } = resultado

      const data = transformarDadosTabelaGrade(grade, tamanhos)
      const columns = retornarColunasTabelaGrade(tamanhos)

      criarTabelaGrade({ data, columns })
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar a grade do produto.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function retornarInputQtde(qtde, cor, tam) {
    const valor = (safeParseInt(qtde) ?? 0)
    return `<div
              class="input-group-append">
                <input
                  type="text"
                  value="${valor}"
                  class="input-default focus form-control validate text-right campoInteger"
                  id="txtQtde_${cor}_${tam}"
                  placeholder="0"
                  style="max-width: 120px"
                >
            </div>`
  }

  function adicionarFormatacaoCampos() {
    $('.campoInteger').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    })
  }

  $('#btnGravar').on('click', function () {
    msgAlerta('Deseja gravar os dados?',
      () => { },
      () => { },
      () => {
        const dados = retornarDadosSalvar()
        salvar(dados)
      },
    )
  })

  function retornarDadosSalvar() {
    const numero = $('#txtNumero').val()
    const descricao = $('#txtDescricao').val()
    const ativo = $('#cbKitAtivo').prop('checked')
    const produto = pegaChave('#txtProduto')

    const datatable = $('#tabelaGrade').DataTable()
    const tamanhosProduto = datatable.columns().dataSrc().toArray().filter((it) => !['cor', 'descCor'].includes(it))

    const grade = datatable.data().toArray().map((it) => {
      const cor = {
        codigo: it.cor,
        tamanhos: []
      }

      tamanhosProduto.forEach((tam) => {
        cor.tamanhos.push({
          codigo: tam,
          qtde: safeParseInt($(`#txtQtde_${it.cor}_${tam}`).val()) ?? 0
        })
      })

      return cor
    })

    return {
      numero,
      descricao,
      ativo,
      produto,
      grade,
    }
  }

  async function salvar(dados) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('POST', `/sisplan/formacao_kit/v1/kit?`, ``, JSON.stringify({ kit: dados }), 3600000)
      const json = await response.json()

      if (json) {
        const { mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/formacao_kit`
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      console.error(error)
      msgErro(error || 'Ocorreu um erro ao gravar os dados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/formacao_kit`
  })
})