<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Nota Complementar</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.18.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.18.1">
  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.18.1" />

  <link href='dist/css/bootstrap.min.css?versao=3.2511.18.1'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="dist/css/responsive.bootstrap.min.css?versao=3.2511.18.1">
  <link rel="shortcut icon" href="favicon.ico">
  <!-- Toastr -->
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.18.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="dist/css/cadastro.css?versao=3.2511.18.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 25%;
      float: left;
      position: relative
    }

    .card-totais {
      margin-top: 2%;
    }

    #txtDados {
      padding-top: .7%;
      padding-left: .85%;
    }

    .input-group-append>a>i {
      margin-left: 0 !important;
      padding-left: 5px;
      padding-right: 5px;
    }

    .grupo_botao>button>i {
      margin-left: 0 !important;
      padding-left: 5px;
      padding-right: 5px;
    }

    .bg-light {
      background-color: #f8f9fa08 !important;
    }

    .focus:read-only:focus {
      border-color: #aa1212 !important;
    }

    .labelCheck {
      font-size: 110%;
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .radiosStyle {
      font-size: 120%;
      margin-top: 1%;
      margin-bottom: 1%;
    }

    .checkboxMoeda {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding: .8%;
    }

    .bordaTab {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      margin-top: 9.6%;
    }

    .configTabPreco {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
    }
  </style>

</head>

<body class="sidebar-mini layout-fixed">
  <div class="wrapper">

    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <section class="content">
        <div class="container-fluid" id="grad1">
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Nota complementar
                    <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>

                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                        <li id="payment"><strong>Nota</strong></li>
                        <li id="personal"><strong>Item</strong></li>
                        <li id="confirm"><strong>Finalização</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar até a conclusão da nota complementar</p>
                      <fieldset>
                        <div class="form-card" id="tourGeral">
                          <h2 class="fs-title">Dados Gerais</h2>
                          <div class="row">

                            <div class="col-sm-12" style="font-size: 140%;">
                              <label class="container">
                                <input type="radio" checked="checked" id="radioNfe" name="tiporef">
                                <span class="checkmark"></span>
                                NF-e
                              </label>
                              <label class="container">
                                <input type="radio" id="radioNfce" name="tiporef">
                                <span class="checkmark"></span>
                                NFC-e
                              </label>
                            </div>

                            <div class="col-lg-12 col-12 form-group mt-2">
                              <label data-error="wrong" data-success="right" for="txtNotaRef">Nota Referenciada *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtNotaRef" name="txtNotaRef" class="form-control" placeholder="Nota Referenciada">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-NotaRef" name="btn-NotaRef" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btn-limpa-NotaRef" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="txtChaveNotaRef">Chave Nota Referenciada *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtChaveNotaRef" name="txtChaveNotaRef" class="form-control" placeholder="Chave Nota Referenciada">
                              </div>
                            </div>

                            <div class="col-lg-6  col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtCliente">Cliente *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                <input type="text" id="txtCNPJ" class="d-none">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="txtDataEmissao">Data emissão</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="txtDataEmissao" name="txtDataEmissao" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="txtDataSaida">Data saída</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="txtDataSaida" name="txtDataSaida" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-9  col-9 form-group">
                              <label data-error="wrong" data-success="right" for="txtNatureza">Natureza *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtNatureza" name="txtNatureza" class="form-control" placeholder="Natureza">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-natureza" name="btn-natureza" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btn-limpa-natureza" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtAliquota">Alíquota</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus maskDecimais form-control" id="txtAliquota" name="txtAliquota" class="form-control" placeholder="Alíquota">
                              </div>
                            </div>

                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="txtDados">Dados Adicionais</label>
                              <textarea style="resize: none" id="txtDados" placeholder="Dados adicionais" class="input-default focus form-control" rows="4"></textarea>
                            </div>

                          </div>
                        </div>
                        <input type="button" id="avancar1" name="next" class="next action-button" value="Avançar" />
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Dados Nota</h2>

                          <div class="row card-totais" style="margin-bottom: 2.5%">

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorIcms">Valor ICMS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorIcms" name="txtValorIcms" class="form-control" placeholder="Valor ICMS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtBaseIcms">Base ICMS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtBaseIcms" name="txtBaseIcms" class="form-control" placeholder="Base ICMS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorIpi">Valor IPI</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorIpi" name="txtValorIpi" class="form-control" placeholder="Valor IPI">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtBaseIpi">Base IPI</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtBaseIpi" name="txtBaseIpi" class="form-control" placeholder="Base IPI">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorIcmsSt">Valor ICMSST</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorIcmsSt" name="txtValorIcmsSt" class="form-control" placeholder="Valor IPI">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtBaseIcmsSt">Base ICMSST</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtBaseIcmsSt" name="txtBaseIcmsSt" class="form-control" placeholder="Base ICMSST">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorPis">Valor PIS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorPis" name="txtValorPis" class="form-control" placeholder="Valor PIS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorCofins">Valor COFINS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorCofins" name="txtValorCofins" class="form-control" placeholder="Valor COFINS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorDesp">Valor Despesas</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorDesp" name="txtValorDesp" class="form-control" placeholder="Valor Despesas">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorFrete">Valor Frete</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorFrete" name="txtValorFrete" class="form-control" placeholder="Valor Frete">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorNota">Valor Nota</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorNota" name="txtValorNota" class="form-control" placeholder="Valor Nota">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorProdutos">Valor Produtos</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorProdutos" name="txtValorProdutos" class="form-control" placeholder="Valor Produtos">
                              </div>
                            </div>

                          </div>
                        </div>

                        <input type="button" id="avancarItens" name="make_payment" class="next action-button" value="Avançar" />
                        <input type="button" name="previous" class="previous action-button-previous" value="Voltar" />

                      </fieldset>
                      <fieldset id="financeiroFs">
                        <div class="form-card">
                          <h2 class="fs-title">Item da Nota    
                            <input type="checkbox" id="checkQtdeZerada"> <label for="checkQtdeZerada" style="font-size: 50%;">Quantidade zerada</label>
                          </h2>

                          <div class="row">

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorIcmsItem">Valor ICMS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorIcmsItem" name="txtValorIcmsItem" class="form-control" placeholder="Valor ICMS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtBaseIcmsItem">Base ICMS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtBaseIcmsItem" name="txtBaseIcmsItem" class="form-control" placeholder="Base ICMS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtPercIpiItem">% IPI</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtPercIpiItem" name="txtPercIpiItem" class="form-control" placeholder="% IPI">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorIpiItem">Valor IPI</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorIpiItem" name="txtValorIpiItem" class="form-control" placeholder="Valor IPI">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtBaseIpiItem">Base IPI</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtBaseIpiItem" name="txtBaseIpiItem" class="form-control" placeholder="Base IPI">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorIcmsStItem">Valor ICMSST</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorIcmsStItem" name="txtValorIcmsStItem" class="form-control" placeholder="Valor IPI">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtBaseIcmsStItem">Base ICMSST</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtBaseIcmsStItem" name="txtBaseIcmsStItem" class="form-control" placeholder="Base ICMSST">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorPisItem">Valor PIS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorPisItem" name="txtValorPisItem" class="form-control" placeholder="Valor PIS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorCofinsItem">Valor COFINS</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorCofinsItem" name="txtValorCofinsItem" class="form-control" placeholder="Valor COFINS">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorDespItem">Valor Despesas</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorDespItem" name="txtValorDespItem" class="form-control" placeholder="Valor Despesas">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorFreteItem">Valor Frete</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorFreteItem" name="txtValorFreteItem" class="form-control" placeholder="Valor Frete">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorItem">Valor Item</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorItem" name="txtValorItem" class="form-control" placeholder="Valor Item">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorLiq">Valor Líquido</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorLiq" name="txtValorLiq" class="form-control" placeholder="Valor Líquido">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorIcmsDeson">Valor ICMS Deson.</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorIcmsDeson" name="txtValorIcmsDeson" class="form-control" placeholder="Valor ICMS Deson.">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtPercDiferimento">% Diferimento</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtPercDiferimento" name="txtPercDiferimento" class="form-control" placeholder="% Diferimento">
                              </div>
                            </div>

                            <div class="col-lg-3  col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtValorDif">Valor Diferimento</label>
                              <div class="input-group">
                                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorDif" name="txtValorDif" class="form-control" placeholder="Valor Diferimento">
                              </div>
                            </div>

                          </div>

                        </div>
                        <input type="button" id="avancarFinanceiro" name="next" class="next action-button" value="Avançar" />
                        <input type="button" name="previous" id="voltarFinanceiro" class="previous action-button-previous" value="Voltar" />
                      </fieldset>
                      <fieldset>
                        <div class="form-card">

                          <h2 class="fs-title">Finalização</h2>

                          <div class="row">
                            <div class="col-lg-12">
                              <input type="checkbox" id="checkGerarIcmsSt"> <label for="checkGerarIcmsSt"> Gerar ICMSST</label>        
                              <input type="checkbox" id="checkConsFinal"> <label for="checkConsFinal"> Consumidor Final</label>        
                              <input type="checkbox" id="checkGerarDifal"> <label for="checkGerarDifal"> Gerar Difal</label>
                            </div>
                            <div class="col-sm-12 mt-3 justify-content-center">
                              <button type="button" id="btnDuplicata" class="btn btn-success btn-sisp">Duplicata</button>
                              <button type="button" id="btnComplemento" class="btn btn-success btn-sisp">Complemento</button>
                              <button type="button" id="btnDifal" class="btn btn-success btn-sisp">Difal</button>
                            </div>
                          </div>

                        </div>
                        <input type="button" id="gravar" name="make_payment" class="action-button" value="Gravar" />
                        <input type="button" name="previous" id="ultimoVoltar" class="previous action-button-previous" value="Voltar" />
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
  <div class="modal fade" id="modalDuplicata" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalDuplicata-titulo" class="modal-title">Duplicata    
            <input type="checkbox" id="checkGeraDup"> <label for="checkGeraDup" style="font-size: 60%;">Gera Duplicata</label>
          </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row d-flex justify-content-center">

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtDataVenc">Data Vencimento</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataVenc" name="txtDataVenc" class="form-control">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtSituacao">Situação *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Situação">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Situacao" name="btn-Situacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Situacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtClasseGer">Classe Gerencial *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" class="form-control" placeholder="Classe Gerencial">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-ClasseGer" name="btn-ClasseGer" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-ClasseGer" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtHistorico">Histórico *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Histórico">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtBanco">Banco *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Banco" name="btn-Banco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Banco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtConta">Conta *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Conta" name="btn-Conta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-4  col-4 form-group">
              <label data-error="wrong" data-success="right" for="txtValorDup">Valor Duplicata *</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtValorDup" name="txtValorDup" class="form-control" placeholder="Valor Duplicata">
              </div>
            </div>

          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btn-confirmar-dup" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalComplemento" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalComplemento-titulo" class="modal-title">Informações do Complemento</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtDescricao">Descrição</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtDescricao" name="txtDescricao" class="form-control" placeholder="Descrição">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" id="lblCstIcms" for="txtCstIcms">CST ICMS *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCstIcms" name="txtCstIcms" class="form-control" placeholder="CST ICMS">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-CstIcms" name="btn-CstIcms" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-CstIcms" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtCstIpi">CST IPI *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCstIpi" name="txtCstIpi" class="form-control" placeholder="CST IPI">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-CstIpi" name="btn-CstIpi" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-CstIpi" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtCstPis">CST PIS *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCstPis" name="txtCstPis" class="form-control" placeholder="CST PIS">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-CstPis" name="btn-CstPis" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-CstPis" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtCstCofins">CST COFINS *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCstCofins" name="txtCstCofins" class="form-control" placeholder="CST COFINS">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-CstCofins" name="btn-CstCofins" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-CstCofins" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtCodNcm">NCM *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCodNcm" name="txtCodNcm" class="form-control" placeholder="NCM">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-CodNcm" name="btn-CodNcm" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-CodNcm" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btn-confirmar-compl" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalDifal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalDifal-titulo" class="modal-title">Grupo Difal</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtPercPobreza">% Pobreza</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtPercPobreza" name="txtPercPobreza" class="form-control" placeholder="% Pobreza">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtPercIcmsDest">% ICMS Dest.</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtPercIcmsDest" name="txtPercIcmsDest" class="form-control" placeholder="% ICMS Dest.">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtBaseIcmsDest">Base ICMS Dest.</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtBaseIcmsDest" name="txtBaseIcmsDest" class="form-control" placeholder="Base ICMS Dest.">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtIndice">Índice</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtIndice" name="txtIndice" class="form-control" placeholder="Índice">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtPercIcmsInter">% ICMS Interestadual</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtPercIcmsInter" name="txtPercIcmsInter" class="form-control" placeholder="% ICMS Interestadual">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtValPobreza">Valor Pobreza</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtValPobreza" name="txtValPobreza" class="form-control" placeholder="Valor Pobreza">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtValIcmsDest">Valor ICMS Destino</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtValIcmsDest" name="txtValIcmsDest" class="form-control" placeholder="Valor ICMS Destino">
              </div>
            </div>

            <div class="col-lg-6  col-6 form-group">
              <label data-error="wrong" data-success="right" for="txtValIcmsRem">Valor ICMS Remetente</label>
              <div class="input-group">
                <input type="text" class="maskDecimais input-default focus form-control" id="txtValIcmsRem" name="txtValIcmsRem" class="form-control" placeholder="Valor ICMS Remetente">
              </div>
            </div>

          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btn-confirmar-difal" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../modais.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.2511.18.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.18.1"></script>
  <!-- SweetAlert2 -->
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.2511.18.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2511.18.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.18.1"></script>

  <script src="dist/js/adminlte.min.js?versao=3.2511.18.1"></script>

  <script src="dist/js/requisicoes.js?versao=3.2511.18.1"></script>
  <script src="dist/js/cliente/entidade.js?versao=3.2511.18.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.2511.18.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2511.18.1"></script>
  <script src="dist/js/popper.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/tippy-bundle.umd.js?versao=3.2511.18.1"></script>
  <script src="utils/funcoes.js?versao=3.2511.18.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2511.18.1"></script>
  <script src="utils/cookies.js?versao=3.2511.18.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2511.18.1"></script>
  <script src="dist/js/dataTables.keyTable2.js?versao=3.2511.18.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2511.18.1"></script>
  <!-- Production -->
  <script type="text/javascript">
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('NOTA_COMPLEMENTAR');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/faturamento/js/nota_complementar.js?versao=3.2511.18.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>