$(document).ready(async function () {
  $('.campoFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  $('#btnEnviarEmail').on('click', function () {
    msgAlerta(
      'Deseja reenviar e-mail para o fornecedor selecionado?',
      () => null,
      () => null,
      () => {
        const dados = retornarDadosEnviarEmail()
        if (!dados) {
          return
        }
        enviarEmail(dados)
      },
    )
  })

  function enviarEmail(dados) {
    $.LoadingOverlay('show')
    enviarEmailParaFornecedores(dados).then(() => {
      toastr.success("Dados enviados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          $('#modalNegociacaoCotacao').modal('hide')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao enviar dados por e-mail.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  async function enviarEmailParaFornecedores(dados) {
    const response = await requisicao("POST", `/sisplan/centralcompras/cotacao/v1/email?`, '', JSON.stringify(dados), 3600000)
    const resultado = await response.json()

    const { mensagem } = resultado
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }
  }

  function retornarDadosEnviarEmail() {
    const idUsuario = getCookie('id_usuario')
    const fornecedores = [{
      codigo: ModalNegociacaoCotacao.fornecedor,
      nome: ModalNegociacaoCotacao.nome,
      numero: ModalNegociacaoCotacao.numero,
    }]
    const complemento = $('#txtComplementoEmail').val()
    const numeroComBarra = ModalNegociacaoCotacao.numero
    const numero = numeroComBarra.substring(0, numeroComBarra.indexOf('/'))

    return {
      idUsuario,
      fornecedores,
      complemento,
      numero,
    }
  }
})

window.ModalNegociacaoCotacao = window.ModalNegociacaoCotacao || {}

ModalNegociacaoCotacao.fornecedor = null
ModalNegociacaoCotacao.nome = null
ModalNegociacaoCotacao.email = null

ModalNegociacaoCotacao.carregar = (dados) => {
  ModalNegociacaoCotacao.fornecedor = dados.fornecedor
  ModalNegociacaoCotacao.nome = dados.nome
  ModalNegociacaoCotacao.numero = dados.numero
  $('#modalNegociacaoCotacao').modal('show')
}