$(document).ready(async function () {
  $('.campoFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  $('#modalMapaCotacao').on('shown.bs.modal', () => {
    setTimeout(
      () => $('#tabelaItensMapaCotacao')?.DataTable()?.columns?.adjust()?.draw(false),
      300,
    )
  })
  $('#modalMapaCotacao').on('hide.bs.modal', () => {
    $('.campoMapaCotacao').val('')
  })

  $('#btnNegociarCotacao').on('click', function () {
    ModalNegociacaoCotacao.carregar({
      fornecedor: ModalMapaCotacaoNegociados.fornecedor,
      nome: ModalMapaCotacaoNegociados.nome,
      numero: ModalMapaCotacaoNegociados.numero,
    })
  })

  $('#tabelaItensMapaCotacao').on('click', '#btnHistorico', async function () {
    const datatable = $('#tabelaItensMapaCotacao').DataTable()
    const { id, codigo, descricao } = datatable?.row($(this)?.parents('tr'))?.data()
    $.LoadingOverlay('show')
    ModalHistoricoNegociacaoCotacao.buscarDados(id).then((resultado) => {
      ModalHistoricoNegociacaoCotacao.carregar({ ...resultado, codigo, descricao })
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  })
})

window.ModalMapaCotacaoNegociados = window.ModalMapaCotacaoNegociados || {}

ModalMapaCotacaoNegociados.fornecedor = null
ModalMapaCotacaoNegociados.nome = null
ModalMapaCotacaoNegociados.numero = null

ModalMapaCotacaoNegociados.carregar = (dados) => {
  const { numero, fornecedor, itens } = dados
  $('#txtFornecedorMapaCotacao').val(fornecedor.codigo)
  $('#txtNomeMapaCotacao').val(fornecedor.nome)
  $('#txtCidadeMapaCotacao').val(fornecedor.cidade)
  $('#txtUfMapaCotacao').val(fornecedor.uf)
  $('#txtDddMapaCotacao').val(fornecedor.ddd)
  $('#txtTelefoneMapaCotacao').val(fornecedor.telefone)
  $('#txtEmailMapaCotacao').val(fornecedor.email)
  ModalMapaCotacaoNegociados.criarTabelaItens(itens)
  $('#tituloModalMapaCotacao').html(`Mapa de Cotação - [${numero}]`)
  ModalMapaCotacaoNegociados.fornecedor = fornecedor.codigo
  ModalMapaCotacaoNegociados.nome = fornecedor.nome
  ModalMapaCotacaoNegociados.numero = numero
  $('#modalMapaCotacao').modal('show')
}

ModalMapaCotacaoNegociados.criarTabelaItens = (data = []) => {
  if ($.fn.DataTable.isDataTable('#tabelaItensMapaCotacao')) {
    $('#tabelaItensMapaCotacao').DataTable().destroy()
    $('#tabelaItensMapaCotacao').empty()
  }

  const columns = [
    {
      data: 'codigo',
      title: 'Código',
      render: function (data) {
        return '<div style="text-align:start;"> ' +
          '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes flex justify-content-between align-items-center" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="min-width: 215px"> ' +
          '      ' + data + ' ' +
          '    </button> ' +
          '    <div class="dropdown-menu"> ' +
          '    <button class="dropdown-item" type="button" title="Editar" id="btnHistorico">Histórico</button>     ' +
          '</div>'
      }
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return retornarFloatFormatadoEmMonetario({ valor: 0, quantidadeCasasDecimais: 2 })
        }
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      },
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return retornarFloatFormatadoEmMonetario({ valor: 0, quantidadeCasasDecimais: 2 })
        }
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      },
    },
    {
      data: 'entrega',
      title: 'Entrega',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      }
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    }
  ]

  $('#tabelaItensMapaCotacao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '500px',
  })
}

ModalMapaCotacaoNegociados.buscarDados = async (numero) => {
  const response = await requisicao(
    "GET",
    `/sisplan/centralcompras/cotacao/v1/detalhesnegociacao?`,
    `NUMERO=${encodeURIComponent(numero)}`,
    '',
    3600000
  )

  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }
}