$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a transportadora.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtCodigo').prop('disabled', true);

    $('#txtTelefone').mask('(00) 0000-00009');

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDesc: {
                    required: true,
                },
                txtCpf: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDesc: {
                    required: "Informe um nome válido."
                },
                txtCpf: {
                    required: "Informe um CPF/CNPJ válido."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#txtCep').autocompleta(1, `JSON={ "tabela":"cadcep", "camposSelect":[ "cep chave", "codmun descricao"], "where": null}`);
    $('#btnCep').pesquisa('#txtCep', 'CEP', 'CODMUN', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcep", "camposSelect":[ "cep", "codmun"]}`, 'Pesquisa CEP', 'cadcep');
    $('#btnACep').on('click', function () {
        $('#txtCep').val('');
    });
    $('#txtUf').autocompleta(1, `JSON={ "tabela":"cadcep", "camposSelect":[ "cep chave", "codmun descricao"], "where": null}`);
    $('#btnUf').pesquisa('#txtUf', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabuf", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa UF', 'tabuf');
    $('#btnAUf').on('click', function () {
        $('#txtUf').val('');
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let transportadora = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('TRANSPORTADORA', getCookie('usuario'), transportadora);
        window.location.href = `${BASE_URI}/transportadora`;
    });

    if (transportadora != '' && transportadora != 'create') {

        if (await liberarRegistro('TRANSPORTADORA', transportadora) == false) {
            window.location.href = '../transportadora';
        } else {

            try {
                $.LoadingOverlay("show");

                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"tabtran", 
                        "camposSelect":["codigo", "nome", "cgc", "inscricao", "cep", "bairro", "endereco", "telefone", "email", "ativo", "email_xml", "forma_coleta", "cod_importado"], 
                        "where": ["codigo = '${transportadora}'"]}`, null);

                    let jsonString = await response.json();
                    if (jsonString.RESULT[0].length > 0) {
                        $('#txtCodigo').val(jsonString.RESULT[0][0].CODIGO);
                        $('#txtDesc').val(jsonString.RESULT[0][0].NOME);
                        $('#txtCpf').val(jsonString.RESULT[0][0].CGC);
                        $('#txtIe').val(jsonString.RESULT[0][0].INSCRICAO);
                        $('#txtBairro').val(jsonString.RESULT[0][0].BAIRRO);
                        $('#txtEndereco').val(jsonString.RESULT[0][0].ENDERECO);
                        $('#txtTelefone').val(jsonString.RESULT[0][0].TELEFONE);
                        $('#txtEmail').val(jsonString.RESULT[0][0].EMAIL);
                        $('#txtEmailNFE').val(jsonString.RESULT[0][0].EMAIL_XML);
                        $('#txtFormaColeta').val(jsonString.RESULT[0][0].FORMA_COLETA);
                        $('#txtCodImportado').val(jsonString.RESULT[0][0].COD_IMPORTADO);

                        if (jsonString.RESULT[0][0].ATIVO == 'S') {
                            $('#checkAtivo').prop('checked', true);
                        } else {
                            $('#checkAtivo').prop('checked', false);
                        }

                        try {
                            response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"cadcep", 
                            "camposSelect":["codmun", "coduf"], 
                            "where": ["cep = '${jsonString.RESULT[0][0].CEP}'"]}`, null);

                            let jsonStr = await response.json();

                            insereValor('#txtCep', jsonString.RESULT[0][0].CEP, jsonStr.RESULT[0][0].CODMUN);

                        } catch (error) {
                            console.error(error);
                        }
                    } else {

                        try {
                            response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"entidade", 
                        "camposSelect":["codcli", "nome", "cnpj", "inscricao", "cep", "bairro", "endereco", "telefone", "email", "cod_importado"], 
                        "where": ["codcli = '${transportadora}'"]}`, null);

                            if (!response) {
                                return;
                            }
                            let jsonStr = await response.json();
                            if (response.status != 200) {
                                msgErro(jsonStr.RESULT[0].mensagem);
                                return;
                            }

                            $('#txtCodigo').val(jsonStr.RESULT[0][0].CODCLI);
                            $('#txtDesc').val(jsonStr.RESULT[0][0].NOME);
                            $('#txtCpf').val(jsonStr.RESULT[0][0].CNPJ);
                            $('#txtIe').val(jsonStr.RESULT[0][0].INSCRICAO);
                            $('#txtBairro').val(jsonStr.RESULT[0][0].BAIRRO);
                            $('#txtEndereco').val(jsonStr.RESULT[0][0].ENDERECO);
                            $('#txtTelefone').val(jsonStr.RESULT[0][0].TELEFONE);
                            $('#txtEmail').val(jsonStr.RESULT[0][0].EMAIL);
                            $('#txtCodImportado').val(jsonStr.RESULT[0][0].COD_IMPORTADO);

                            try {
                                response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                    `JSON={ "tabela":"cadcep", 
                            "camposSelect":["codmun", "coduf"], 
                            "where": ["cep = '${jsonStr.RESULT[0][0].CEP}'"]}`, null);

                                jsonString = await response.json();

                                insereValor('#txtCep', jsonStr.RESULT[0][0].CEP, jsonString.RESULT[0][0].CODMUN);

                            } catch (error) {
                                console.error(error);
                            }

                        } catch (error) {
                            msgErro(`Não foi possível buscar os dados da transportadora: ${error}`);
                        }
                    }
                    if ($('#txtFormaColeta').val() == '' || $('#txtFormaColeta').val() == null){
                        $('#txtFormaColeta').val('E')
                    }
                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(
        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    transportadora = {};

                    transportadora.CODIGO = $('#txtCodigo').val();
                    transportadora.NOME = $('#txtDesc').val();
                    transportadora.CGC = $('#txtCpf').val();
                    transportadora.INSCRICAO = $('#txtIe').val();
                    transportadora.CEP = pegaChave('#txtCep', transportadora.CEP);
                    transportadora.BAIRRO = $('#txtBairro').val();
                    transportadora.ENDERECO = $('#txtEndereco').val();
                    transportadora.EMAIL = $('#txtEmail').val();
                    transportadora.EMAILXML = $('#txtEmailNFE').val();
                    transportadora.TELEFONE = $('#txtTelefone').val();
                    transportadora.FORMACOLETA = $('#txtFormaColeta').val()

                    if ($('#txtCpf').val().length < 14) {
                        transportadora.TIPO = '1';
                    } else {
                        transportadora.TIPO = '2';
                    }

                    if ($('#checkAtivo').prop('checked')) {
                        transportadora.ATIVO = 'S';
                    } else {
                        transportadora.ATIVO = 'N';
                    }

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/transportadora?', `JSON=${encodeURIComponent(JSON.stringify(transportadora))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro da transportadora: ${transportadora.CODIGO} efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/transportadora`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } catch (error) {
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados da transportadora: ${error}`);
                }
            }
        });
});
