$(document).ready(async function () {

  $('#boxFechamento').css('width', `${parseInt($('#txtPagamento').css('width')) + parseInt($('#btnPagamento').css('width')) + 25}px`)

  $('#txtPagamento').val(formataData(new Date()));

  function adicionaMascaraCampos() {
    $('.apenasFloat').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.apenasInteiros').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.relFacPag == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
      ...colunas, relFacPag: []
    }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // const relatorios = await retornaOrdensRelatorio('RelFacPag');
  preencheOrdenacaoTela('RelFacPag');

  // relatorios.forEach(function (item) {
  //   $("#txtOrdem").append(
  //     `<option value=${item.ORDEM} nome_prt=${item.NOME_PRT}>${item.NOME_ORD_TELA}</option>`
  //   );
  // });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relFacPag: novasColunas }))

      $('#tabelaDados').DataTable().columns().visible(true);

      $('#tabelaDados').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  })

  componenteFiltro('produto', true, true);
  componenteFiltro('setor', true, true);
  componenteFiltro('marca', true, true);
  componenteFiltro('colecao', true, true);
  componenteFiltro('entidade', true, true, 'Faccao');
  componenteFiltro('pedido', true, true);
  componenteFiltro('grupo', true, true);
  componenteFiltro('programacao', true, true);
  componenteFiltro('notaFac', true, true, 'Nota');
  componenteFiltro('parte', true, true);
  componenteFiltro('etiqueta', true, true);
  componenteFiltro('descAcresc', true, true, 'DescAcresc');
  componenteFiltro('funcionario', true, true);
  componenteFiltro('movimento', true, true);
  componenteFiltro('maquina', true, true);
  componenteFiltro('composicao', true, true);
  componenteFiltro('linha', true, true);
  componenteFiltro('tipo', false, false);
  componenteFiltro('gramatura', true, true);
  componenteFiltro('deposito', true, true);
  componenteFiltro('grupoCli', true, true);
  componenteFiltro('celula', true, true);
  componenteFiltro('empresa', true, true);
  componenteFiltro('cliente', true, true);
  componenteFiltro('tabPrazo', false, false, 'PeriodoOFDe');
  componenteFiltro('tabPrazo', false, false, 'PeriodoOFAte');
  componenteFiltro('classe', false, false, 'ClassePagamento');
  componenteFiltro('historico', false, false, 'HistoricoPagamento');
  componenteFiltro('banco', false, false, 'BancoPagamento');
  componenteFiltro('situacao', false, false, 'SituacaoPagamento');

  const pesquisaAutoCompleta = {
    ... {
      tabela: 'FACCAO',
      camposSelect: ['FACCAO.NUMERO NUMERO', 'FACCAO.NUMERO NUMERO2'],
      camposSelectSubSelect: ['NUMERO', 'NUMERO2'],
      groupBy: ['FACCAO.NUMERO'],
      groupBySubSelect: ['NUMERO', 'NUMERO2'],
      camposWhereServerSide: ['FACCAO.NUMERO']
    }, camposSelect: ['FACCAO.NUMERO NUMERO', 'FACCAO.NUMERO NUMERO2']
  }

  const pesquisaSel = {
    tabela: 'FACCAO',
    camposSelect: ['FACCAO.NUMERO NUMERO', 'FACCAO.NUMERO NUMERO2'],
    camposSelectSubSelect: ['NUMERO', 'NUMERO2'],
    groupBy: ['FACCAO.NUMERO'],
    groupBySubSelect: ['NUMERO', 'NUMERO2'],
    camposWhereServerSide: ['FACCAO.NUMERO']
  }

  $('#txtOF').pesquisa_variosServerside(1, `${JSON.stringify(pesquisaAutoCompleta)}`, 'NUMERO', 'NUMERO2');
  $('#btnOF').pesquisa_serversideSel('#txtOF', `${JSON.stringify(pesquisaSel)}`, 'Pesquisa OF');
  $('#btnLimpaOF').on('click', function () {
    $('#txtOF').empty();
    $('#txtOF').trigger('change');
  })

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      if (!$('#txtOrdem').val()) {
        msgErro('Nenhuma ordenação selecionada. Impossível continuar.');
        return;
      }

      await buscaDados();
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
      if ($('#tabelaDados').DataTable().data().length > 0) {
        $($('#tabelaDados tr')[1]).trigger('click');
      }
    }
  });

  async function buscaDados() {
    try {
      const filtros = await retornaFiltros();

      const url = `/sisplan/relfacpag/v1/buscadados?`;
      const ordem = `&TELA_ORDENACAO=RelFacPag&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const response = await requisicao("GET", url, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, '', 1800000);

      if (!response) {
        return;
      }

      const data = await response.json();

      criaTabela(data);

    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    }
  };

  async function retornaFiltros() {
    const result = {};

    result.filtro_of = $('input[name="rdFiltrarOF"]:checked').val();
    result.busca = $('input[name="rdBuscar"]:checked').val();
    result.buscar_descacresc = $('#cbDescAcresc').prop('checked');
    result.ident_apos_numero = $('#cbIdentAposNumero').prop('checked');
    result.filtrar_ofs = $('#cbFiltrarOFs').prop('checked');
    result.filtrar_colecoes = $('#cbFiltrarColecoes').prop('checked');
    result.buscar_pendentes = $('#cbBuscarPendentes').prop('checked');
    result.buscar_reprocesso = $('#cbBuscarReprocesso').prop('checked');
    result.pagina_por_faccao = $('#cbPaginaPorFaccao').prop('checked');
    result.validar_of_pedidos = $('#cbValidarOFPedidos').prop('checked');
    result.somente_indice_reprocesso = $('#cbIndiceReprocesso').prop('checked');
    result.somente_defeitos_valor = $('#cbDefeitosValor').prop('checked');
    result.buscar_inspecoes = $('#cbBuscarInspecoes').prop('checked');
    result.filtrar_depositos_lancamentos = $('#cbDepositoLanc').prop('checked');
    result.buscar_consumos_baixados = $('#cbBuscarConsumos').prop('checked');
    result.buscar_lancamento_defeitos = $('#cbLancDefeitos').prop('checked');
    result.retorno_de = $('#dtRetornoDe').val();
    result.retorno_ate = $('#dtRetornoAte').val();
    result.envio_de = $('#dtEnvioDe').val();
    result.envio_ate = $('#dtEnvioAte').val();
    result.pagamento_de = $('#dtPagamentoDe').val();
    result.pagamento_ate = $('#dtPagamentoAte').val();
    result.ap_de = $('#txtAPDe').val();
    result.ap_ate = $('#txtAPAte').val();
    result.of_de = $('#txtOFDe').val();
    result.of_ate = $('#txtOFAte').val();
    result.periodo_of_de = pegaChave('#txtPeriodoOFDe');
    result.periodo_of_ate = pegaChave('#txtPeriodoOFAte');
    result.produto = (await formataListas($('#txtProduto').val().toString()));
    result.setor = (await formataListas($('#txtSetor').val().toString()));
    result.marca = (await formataListas($('#txtMarca').val().toString()));
    result.colecao = (await formataListas($('#txtColecao').val().toString()));
    result.faccao = (await formataListas($('#txtFaccao').val().toString()));
    result.pedido = (await formataListas($('#txtPedido').val().toString()));
    result.grupo = (await formataListas($('#txtGrupo').val().toString()));
    result.ficha = $('#txtFicha').val();
    result.programacao = (await formataListas($('#txtProgramacao').val().toString()));
    result.nota = (await formataListas($('#txtNota').val().toString()));
    result.parte = (await formataListas($('#txtParte').val().toString()));
    result.etiqueta = (await formataListas($('#txtEtiqueta').val().toString()));
    result.lote = $('#txtLote').val();
    result.descacresc = (await formataListas($('#txtDescAcresc').val().toString()));
    result.funcionario = (await formataListas($('#txtFuncionario').val().toString()));
    result.mov = (await formataListas($('#txtMovimento').val().toString()));
    result.maquina = (await formataListas($('#txtMaquina').val().toString()));
    result.composicao = (await formataListas($('#txtComposicao').val().toString()));
    result.linha = (await formataListas($('#txtLinha').val().toString()));
    result.ordem_producao = (await formataListas($('#txtOF').val().toString()));
    result.tipo = pegaChave('#txtTipo');
    result.gramatura = (await formataListas($('#txtGramatura').val().toString()));
    result.deposito = (await formataListas($('#txtDeposito').val().toString()));
    result.grupo_cli = (await formataListas($('#txtGrupoCli').val().toString()));
    result.celula = (await formataListas($('#txtCelula').val().toString()));
    result.empresa = (await formataListas($('#txtEmpresa').val().toString()));
    result.cliente = (await formataListas($('#txtCliente').val().toString()));
    result.considerar_faccao = $('#cbConsiderarFaccao').prop('checked');
    result.considerar_of = $('#cbConsiderarOF').prop('checked');

    return result;
  }

  function criaTabela(info = undefined) {
    $.LoadingOverlay('show')
    try {
      function retornaBotaoSel(meta, data) {
        let marcado = '';
        if (data == 'S') {
          marcado = 'checked';
        }
  
        return `<div class="icheck-primary">
                  <input type="checkbox" ${marcado} id="check_${meta.row}" class="checkSel">
                  <label for="check_${meta.row}"></label>
                </div>`
      };
  
      const data = info ?? ($.fn.DataTable.isDataTable('#tabelaDados') ? $('#tabelaDados').DataTable().rows().data().toArray() : undefined);

      if (!data){
        return;
      }
  
      if ($.fn.DataTable.isDataTable('#tabelaDados')) {
        $('#tabelaDados').DataTable().destroy();
        $('#tabelaDados').empty();
      }
  
      const cols = [{
        data: 'SEL',
        title: 'Sel'
      },
      {
        data: 'NUMERO',
        title: 'Número'
      },
      {
        data: 'LANCTO',
        title: 'Lançamento'
      },
      {
        data: 'MOVIMENTO',
        title: 'Mov'
      },
      {
        data: 'CODCLI',
        title: 'Codcli'
      },
      {
        data: 'NOME',
        title: 'Nome'
      },
      {
        data: 'CODIGO',
        title: 'Código'
      },
      {
        data: 'DESCRICAO',
        title: 'Descrição'
      },
      {
        data: 'POS_TAMANHO',
        title: 'Posição Tamanho'
      },
      {
        data: 'TAM',
        title: 'Tam'
      },
      {
        data: 'COR',
        title: 'Cor'
      },
      {
        data: 'DESC_COR',
        title: 'Desc. Cor'
      },
      {
        data: 'QUANT',
        title: 'Qtde'
      },
      {
        data: 'DT_S',
        title: 'Data Saída'
      },
      {
        data: 'DT_R',
        title: 'Data Retorno'
      },
      {
        data: 'DT_LAN',
        title: 'Data Lançamento'
      },
      {
        data: 'OP',
        title: 'Setor'
      },
      {
        data: 'DESC_SETOR',
        title: 'Desc. Setor'
      },
      {
        data: 'PARTE',
        title: 'Parte'
      },
      {
        data: 'DESC_PARTE',
        title: 'Desc. Parte'
      },
      {
        data: 'QT_ORIG',
        title: 'Qtde Orig'
      },
      {
        data: 'QUANT_2',
        title: 'Qtde 2ª'
      },
      {
        data: 'QUANT_I',
        title: 'Qtde Incompletas'
      },
      {
        data: 'QUANT_F',
        title: 'Qtde Perdidas'
      },
      {
        data: 'QUAL',
        title: 'Qual'
      },
      {
        data: 'FAC_UNITARIO',
        title: 'Fac Unitário'
      },
      {
        data: 'UNITARIO',
        title: 'Unitário'
      },
      {
        data: 'DT_PAGTO',
        title: 'Data Pagamento'
      },
      {
        data: 'PAGO',
        title: 'Pago'
      },
      {
        data: 'NUM_AP',
        title: 'Num AP'
      },
      {
        data: 'ID_ANT',
        title: 'Id Ant'
      },
      {
        data: 'MOV_ANT',
        title: 'Mov Ant'
      },
      {
        data: 'MOV_REF',
        title: 'Mov Ref'
      },
      {
        data: 'REPROCESSO',
        title: 'Reprocesso'
      },
      {
        data: 'PERC_INTERNO',
        title: 'Perc. Interno'
      },
      {
        data: 'VALOR_INTERNO',
        title: 'Valor Interno'
      },
      {
        data: 'PERC_EXTERNO',
        title: 'Perc. Externo'
      },
      {
        data: 'VALOR_EXTERNO',
        title: 'Valor Externo'
      },
      {
        data: 'PERC_GERAL',
        title: 'Perc. Geral'
      },
      {
        data: 'VALOR_GERAL',
        title: 'Valor Geral'
      }];
  
      const camposDireita = [];
  
      cols.forEach((item, index) => {
        if (['Posição Tamanho', 'Qtde', 'Qtde Orig', 'Qtde 2ª', 'Qtde Incompletas', 'Qtde Perdidas', 'Qual'].includes(item.title)) {
          camposDireita.push(index);
        }
      })

      const scrollY = $('#cbBuscarConsumos').is(':checked') ? '200px' : '300px'
  
      $("#tabelaDados").DataTable({
        sort: true,
        paging: true,
        destroy: true,
        colReorder: true,
        autoWidth: true,
        data: data,
        columns: cols,
        scrollY: scrollY,
        scrollX: true,
        processing: true,
        columnDefs: [
          {
            targets: [0],
            render: function (data, type, row, meta) {
              return retornaBotaoSel(meta, data);
            }
          },
          {
            type: "date-br",
            render(data) {
              if (data) {
                return new Intl.DateTimeFormat("pt-BR").format(
                  new Date(`${data.split(" ")[0]} 23:59:59`)
                );
              } else {
                return '';
              }
            },
            targets: [13, 14, 15, 27],
          },
          {
            targets: [25, 26, 34, 35, 36, 37, 38, 39],
            render: function (data) {
              const v = !data ? 0 : data;
              return parseFloat(v).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            },
            "className": 'pr-4 text-right'
          },
          {
            targets: camposDireita,
            className: "text-right pr-2"
          }
        ],
      });
  
      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  
      $('#tabelaDados_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaDados_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
  
      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')
  
      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });
  
      $("#buttonExcel").on("click", async function () {
        if ($('#txtOrdem').val() == '') {
          msgErro('Nenhuma ordenação selecionada. Impossível continuar.');
          return;
        }
  
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelFacPag&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const url = `/sisplan/relfacpag/v1/buscadados?`;
        await exportaCSV(
          url,
          `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`,
          false,
          600000,
          "Relatório de Pagamento Facção",
          "#tabelaDados"
        );
      });
  
      $('#tabelaDados').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relFacPag).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )
  
      $('#tabelaDados').on('click', 'tr', async function () {
        if ($('#cbBuscarConsumos').prop('checked')) {
          $.LoadingOverlay('show');
          try {
            $('#tabelaDados').DataTable().$('tr.selected').removeClass('selected');
            const data = $('#tabelaDados').DataTable().row($(this)).data();
            $(this).addClass('selected');
            await buscaConsumos(data);
          } finally {
            $.LoadingOverlay('hide');
          }
        }
      });
  
      $('#tabelaDados').on('change', '.checkSel', function () {
        let rowIdx = $(this).attr('id').split('_')[1];
  
        let newData = $('#tabelaDados').DataTable().row(rowIdx).data();
        newData.SEL = this.checked ? 'S' : 'N';
        $('#tabelaDados').DataTable().row(rowIdx).data(newData);
      });
  
      const dados = $('#tabelaDados').DataTable().data().toArray();
  
      const dadosComValor = dados.map(item => ({
        ...item,
        VALOR: TruncaDecimaisNova(2, item.FAC_UNITARIO * item.QUANT),
      }));
  
      Graficos.criarGrafico({
        container: 'graficoRelFacPag',
        tipo: 'column',
        dados: dadosComValor,
        nomeSerie: 'Valor',
        colunasAgrupamento: ['NOME'],
        colunasValor: ['VALOR'],
        title: 'Valor por terceiro'
      });
  
      Graficos.criarGrafico({
        container: 'graficoRelFacPag1',
        tipo: 'pie',
        dados: dadosComValor,
        nomeSerie: 'Valor',
        colunasAgrupamento: ['DESC_SETOR'],
        colunasValor: ['VALOR'],
        title: 'Valor por setor'
      });
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#cbBuscarConsumos').on('change', function () {
    if ($(this).prop('checked')) {
      $('#cardDados').css('max-height', '350px');
      $('#cardConsumos').removeClass('d-none');
    } else {
      $('#cardDados').css('max-height', '450px');
      $('#cardConsumos').addClass('d-none');
      $('#tabelaDados').DataTable().$('tr.selected').removeClass('selected');
    }
    criaTabela();
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaDados').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relFacPag ?? [])
  })

  $('#cbDescAcresc').on('change', function () {
    if ($(this).prop('checked')) {
      $('#cbIdentAposNumero').prop('disabled', false);
      $('.classDescAresc').removeClass('d-none');
    } else {
      $('#cbIdentAposNumero').prop('disabled', true);
      $('.classDescAresc').addClass('d-none');
      $('#cbIdentAposNumero').prop('checked', false);
    }
  });

  limparFiltros(true);

  async function buscaConsumos(data) {
    try {
      const url = `/sisplan/relfacpag/v1/buscaconsumos?`;
      const response = await requisicao("GET", url, `&QUANT=${data.QUANT}&CODCLI=${data.CODCLI}&CODIGO=${data.CODIGO}&COR=${data.COR}&NUMERO=${data.NUMERO}&SETOR=${data.OP}&PARTE=${data.PARTE}`, '', 600000);

      if (!response) {
        return;
      }

      const dados = await response.json();

      criaTabelaConsumos(dados);

    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os consumos: ${e}`)
    }
  }

  retornaHintRelatorio('btnImprimir', 'RelFacPag')

  $('#txtOrdem').on('change', function () {
    retornaHintRelatorio('btnImprimir', $('#txtOrdem option')
      .toArray()
      .map(map => { return [map.selected, $(map).attr('nome_prt')] })
      .filter(filter => filter[0] == true)[0][1])
  })

  function criaTabelaConsumos(info) {
    if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
      $('#tabelaConsumos').DataTable().destroy();
      $('#tabelaConsumos').empty();
    }

    const cols = [{
      data: 'CODCLI',
      title: 'Codcli'
    },
    {
      data: 'CODIGO',
      title: 'Código'
    },
    {
      data: 'DESCRICAO',
      title: 'Descrição'
    },
    {
      data: 'CONS_UNITARIO',
      title: 'Unitário'
    },
    {
      data: 'NUM_OF',
      title: 'Número OF'
    },
    {
      data: 'PRECO',
      title: 'Preço'
    },
    {
      data: 'QTDE_CONSUMO',
      title: 'Qtde Consumo'
    },
    {
      data: 'QTDE_MAT_MOV',
      title: 'Qtde Mat Mov'
    },
    {
      data: 'QTDE_OF',
      title: 'Qtde OF'
    },
    {
      data: 'SETOR',
      title: 'Setor'
    },
    {
      data: 'UNIDADE',
      title: 'Unidade'
    },
    {
      data: 'VALOR',
      title: 'Valor'
    }];

    $("#tabelaConsumos").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      colReorder: true,
      lengthChange: false,
      filter: false,
      autoWidth: true,
      data: info,
      columns: cols,
      columnDefs: [
        {
          targets: [5, 11],
          render: function (data) {
            const v = !data ? 0 : data;
            return parseFloat(v).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            });
          },
        },
        {
          targets: [3, 6, 7],
          render: function (data) {
            const v = !data ? 0 : data;
            return parseFloat(v).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            });
          },
        },
      ],
    });
  }

  $('#btnImprimir').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      if (!$('#txtOrdem').val()) {
        msgErro('Nenhuma ordenação selecionada. Impossível continuar.');
        return;
      }
      await imprimeDados();
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function imprimeDados() {
    try {
      let url = `/sisplan/impressao/v1/imprimirrelfacpag?`;

      const filtros = await retornaFiltros();
      const ordem = `&TELA_ORDENACAO=RelFacPag&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelFacPag');
      let arquivo = await GeraRelatorio(`${url}&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'GET', 1000000, false, 'RelFacPag');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível realizar a impressão: ${e}`);
    }
  }

  $('#btnPagamento').on('click', async function () {
    $.LoadingOverlay('show');
    await iniciaPagamento()
    $.LoadingOverlay('hide');
  });

  async function iniciaPagamento() {
    try {

      if (!$.fn.DataTable.isDataTable('#tabelaDados')) {
        msgErro('Utilize o filtro para retornar os registros.');
        return;
      }

      let data = $('#tabelaDados').DataTable().data().toArray().filter(function (e) {
        return e.SEL == 'S';
      });

      if (data.length == 0) {
        msgErro('Nenhum registro selecionado. Impossível continuar.');
        return;
      }

      let pagamento = $('#txtPagamento').val() == '' ? '1200-01-01' : $('#txtPagamento').val();

      let response = await requisicao("POST", `/Sisplan/relfacpag/V1/gerapagamentos?&CODUSUARIO=${getCookie('cod_usuario')}`, ``, `&DADOS=${encodeURIComponent(JSON.stringify(data))}&PAGAMENTO=${pagamento}`, 60000);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      criaTabelaPagamentos(json);
      $('#modal-pagamento-faccao').modal('show');

    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível realizar o pagamento: ${e}`);
    }
  }

  function criaTabelaPagamentos(info) {

    info = info.map(e => {
      return { ...e, VALOR: parseFloat(e.VALOR).toFixed(2) };
    })

    function carregaInput(valor, indices) {
      try {

        switch (indices.col) {
          case 1: {
            const value = valor.CODCRE != '' ? insereValor(`#txtCodCre_${indices.row}`, valor.CODCRE, valor.NOME) : '';

            return `<div class="input-group-append">
                              <input type="text" value="${value}"
                              class="input-default focus form-control validate classCodCre" style="width: 33ch;" id="txtCodCre_${indices.row}" name="txtCodCre_${indices.row}" placeholder="Codcre">
                              <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCodCre_${indices.row}" name="btnCodCre_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaCodCre_${indices.row}" name="btnLimpaCodCre_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                          </div>`;
          }
          case 2: {
            return `<input type="text" id="txtValor_${indices.row}"
                          class="input-default focus form-control tamanhoDinamico apenasFloat text-right"
                          style="width: 20ch" value="${valor.VALOR}">`;
          }
          case 3: {
            const value = valor.CLASSE != '' ? insereValor(`#txtClasse_${indices.row}`, valor.CLASSE, valor.DESC_CLASSE) : '';

            return `<div class="input-group-append">
                              <input type="text" value="${value}"
                              class="input-default focus form-control validate classClasse" style="width: 33ch;" id="txtClasse_${indices.row}" name="txtClasse_${indices.row}" placeholder="Classe">
                              <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnClasse_${indices.row}" name="btnClasse_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaClasse_${indices.row}" name="btnLimpaClasse_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                          </div>`;
          }
          case 4: {
            const value = valor.HISTORICO != '' ? insereValor(`#txtHistorico_${indices.row}`, valor.HISTORICO, valor.DESC_HISTORICO) : '';

            return `<div class="input-group-append">
                              <input type="text" value="${value}"
                              class="input-default focus form-control validate classHistorico" style="width: 33ch;" id="txtHistorico_${indices.row}" name="txtHistorico_${indices.row}" placeholder="Histórico">
                              <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnHistorico_${indices.row}" name="btnHistorico_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaHistorico_${indices.row}" name="btnLimpaHistorico_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                          </div>`;
          }
          case 5: {
            const value = valor.BANCO != '' ? insereValor(`#txtBanco_${indices.row}`, valor.BANCO, valor.DESC_BANCO) : '';

            return `<div class="input-group-append">
                              <input type="text" value="${value}"
                              class="input-default focus form-control validate classBanco" style="width: 33ch;" id="txtBanco_${indices.row}" name="txtBanco_${indices.row}" placeholder="Banco">
                              <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnBanco_${indices.row}" name="btnBanco_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaBanco_${indices.row}" name="btnLimpaBanco_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                          </div>`;
          }
          case 6: {
            return `<input type="text" id="txtObservacao_${indices.row}"
                          class="input-default focus form-control"
                          style="min-width: 40ch" value="${valor.OBSERVACAO}" placeholder="Observação">`;
          }
          case 7: {
            return `<input type="date" id="txtEmissao_${indices.row}"
                          class="input-default focus form-control"
                          style="width: 25ch" value="${formataData(new Date(valor.DT_EMISSAO))}">`;
          }
          case 8: {
            return `<input type="date" id="txtCompetencia_${indices.row}"
                          class="input-default focus form-control"
                          style="width: 25ch" value="${formataData(new Date(valor.DT_COMPETENCIA))}">`;
          }
          case 9: {
            return `<input type="date" id="txtVencimento_${indices.row}"
                          class="input-default focus form-control classVencimento"
                          style="width: 25ch" value="${formataData(new Date(valor.DT_VENCTO))}">`;
          }
          case 10: {
            const value = valor.SITUACAO != '' ? insereValor(`#txtSituacao_${indices.row}`, valor.SITUACAO, valor.DESC_SITUACAO) : '';

            return `<div class="input-group-append">
                              <input type="text" value="${value}"
                              class="input-default focus form-control validate classSituacao" style="width: 33ch;" id="txtSituacao_${indices.row}" name="txtSituacao_${indices.row}" placeholder="Situação">
                              <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnSituacao_${indices.row}" name="btnSituacao_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaSituacao_${indices.row}" name="btnLimpaSituacao_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                          </div>`;
          }
          default:
            break;
        }
      } catch (e) {
        msgErro(`Não foi possível carregar os dados: ${e}`);
        console.log(e);
      }
    }

    function retornaBotaoSel(meta, data) {
      let marcado = '';
      if (data == 'S') {
        marcado = 'checked';
      }

      return `<div class="icheck-primary">
                <input type="checkbox" ${marcado} id="checkPag_${meta.row}" class="checkSelPag">
                <label for="checkPag_${meta.row}"></label>
              </div>`
    };

    if ($.fn.DataTable.isDataTable('#tabelaPagamentos')) {
      $('#tabelaPagamentos').DataTable().destroy();
      $('#tabelaPagamentos').empty();
    }

    const cols = [{
      data: 'SEL',
      title: 'Sel'
    },
    {
      data: 'CODCRE',
      title: 'Codcre'
    },
    {
      data: 'VALOR',
      title: 'Valor'
    },
    {
      data: 'CLASSE',
      title: 'Classe'
    },
    {
      data: 'HISTORICO',
      title: 'Histórico'
    },
    {
      data: 'BANCO',
      title: 'Banco'
    },
    {
      data: 'OBSERVACAO',
      title: 'Observação'
    },
    {
      data: 'DT_EMISSAO',
      title: 'Emissão'
    },
    {
      data: 'DT_COMPETENCIA',
      title: 'Competência'
    },
    {
      data: 'DT_VENCTO',
      title: 'Vencimento'
    },
    {
      data: 'SITUACAO',
      title: 'Situação'
    }];

    $("#tabelaPagamentos").DataTable({
      sort: true,
      paging: false,
      destroy: true,
      colReorder: true,
      lengthChange: false,
      filter: false,
      autoWidth: true,
      data: info,
      columns: cols,
      columnDefs: [
        {
          targets: [0],
          render: function (data, type, row, meta) {
            return retornaBotaoSel(meta, data);
          }
        },
        {
          targets: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
          render: function (data, v2, v3, index) {
            return carregaInput(v3, index);
          }
        }
      ],
    });

    $('#txtValorTotal').val(parseFloat($('#tabelaPagamentos').DataTable().data().toArray().reduce((e, o) => {
      return parseFloat(e) + parseFloat(o.VALOR);
    }, 0)).toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    })
    );

    adicionaMascaraCampos();
    adicionaPesquisasInputs();
  }

  function adicionaPesquisasInputs() {
    try {
      $('.classCodCre').map(function (e, i) {
        $(`#txtCodCre_${e}`).autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
        $(`#btnCodCre_${e}`).pesquisa(`#txtCodCre_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "ENTIDADE","camposSelect": ["ENTIDADE.CODCLI CODIGO", "ENTIDADE.NOME DESCRICAO"]}`, 'Pesquisa Entidade', 'ENTIDADE');
        $(`#btnLimpaCodCre_${e}`).on('click', function () {
          $(`#txtCodCre_${e}`).val('');
        });

        $(`#txtClasse_${e}`).autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $(`#btnClasse_${e}`).pesquisa(`#txtClasse_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CLASSE_GER","camposSelect": ["CLASSE_GER.CODIGO CODIGO", "CLASSE_GER.DESCRICAO DESCRICAO"]}`, 'Pesquisa Classe', 'CLASSE_GER');
        $(`#btnLimpaClasse_${e}`).on('click', function () {
          $(`#txtClasse_${e}`).val('');
        });

        $(`#txtHistorico_${e}`).autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $(`#btnHistorico_${e}`).pesquisa(`#txtHistorico_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "HISTCP", "camposSelect": ["HISTCP.HISTORICO CODIGO", "HISTCP.DESCRICAO DESCRICAO"]}`, 'Pesquisa Histórico', 'HISTCP');
        $(`#btnLimpaHistorico_${e}`).on('click', function () {
          $(`#txtHistorico_${e}`).val('');
        });

        $(`#txtBanco_${e}`).autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
        $(`#btnBanco_${e}`).pesquisa(`#txtBanco_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADBAN","camposSelect": ["CADBAN.BANCO CODIGO", "CADBAN.NOME_BANCO DESCRICAO"]}`, 'Pesquisa Banco', 'CADBAN');
        $(`#btnLimpaBanco_${e}`).on('click', function () {
          $(`#txtBanco_${e}`).val('');
        });

        $(`#txtSituacao_${e}`).autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $(`#btnSituacao_${e}`).pesquisa(`#txtSituacao_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABSIT", "camposSelect": ["TABSIT.CODIGO CODIGO", "TABSIT.DESCRICAO DESCRICAO"]}`, 'Pesquisa Situação', 'TABSIT');
        $(`#btnLimpaSituacao_${e}`).on('click', function () {
          $(`#txtSituacao_${e}`).val('');
        });
      });
    } catch (e) {
      console.log(e);
    }
  }

  $('#btnClickClassePagamento').on('click', function () {
    $('.classClasse').val($('#txtClassePagamento').val());
  })
  $('#btnClickHistoricoPagamento').on('click', function () {
    $('.classHistorico').val($('#txtHistoricoPagamento').val());
  })
  $('#btnClickBancoPagamento').on('click', function () {
    $('.classBanco').val($('#txtBancoPagamento').val());
  })
  $('#btnClickSituacaoPagamento').on('click', function () {
    $('.classSituacao').val($('#txtSituacaoPagamento').val());
  })
  $('#btnClickVencimentoPagamento').on('click', function () {
    $('.classVencimento').val($('#txtVencimentoPagamento').val());
  })

  $('#btnGerarAPs').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      await gravaAPs();
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function gravaAPs() {
    try {
      let data = $('#tabelaDados').DataTable().data().toArray().filter(function (e) {
        return e.SEL == 'S';
      });

      const dataPag = [];

      $('#tabelaPagamentos').DataTable().rows().every(function (rowIdx) {
        let checkbox = $('#tabelaPagamentos').DataTable().row(rowIdx).nodes().to$().find('.checkSelPag');

        if (checkbox.prop('checked')) {
          dataPag.push({
            CODCRE: pegaChave(`#txtCodCre_${rowIdx}`),
            VALOR: $(`#txtValor_${rowIdx}`).val(),
            CLASSE: pegaChave(`#txtClasse_${rowIdx}`),
            HISTORICO: pegaChave(`#txtHistorico_${rowIdx}`),
            BANCO: pegaChave(`#txtBanco_${rowIdx}`),
            OBSERVACAO: $(`#txtObservacao_${rowIdx}`).val(),
            DT_EMISSAO: $(`#txtEmissao_${rowIdx}`).val(),
            DT_COMPETENCIA: $(`#txtCompetencia_${rowIdx}`).val(),
            DT_VENCTO: $(`#txtVencimento_${rowIdx}`).val(),
            SITUACAO: pegaChave(`#txtSituacao_${rowIdx}`),
            EMPID: getCookie('emp_id')
          });
        }
      });

      if (dataPag.length == 0) {
        msgErro('Nenhum registro selecionado. Impossível continuar.');
        return;
      }

      let pagamento = $('#txtPagamento').val() == '' ? '1200-01-01' : $('#txtPagamento').val();

      let response = await requisicao("POST", `/Sisplan/relfacpag/V1/gravapagamentos?&CODUSUARIO=${getCookie('cod_usuario')}`, ``, `&DADOS=${encodeURIComponent(JSON.stringify(data))}&DADOS_PAG=${encodeURIComponent(JSON.stringify({ ITENS: dataPag }))}&PAGAMENTO=${pagamento}`, 3600000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal-pagamento-faccao').modal('hide');
          $('#btnConsultar').trigger('click');
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gravar os dados: ${e}`)
    }
  }

  $('#btnFecharPagamento').on('click', function () {
    $('#modal-pagamento-faccao').modal('hide');
  })
});
