$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique nesse botão para filtrar sua consulta.',
                position: 'bottom'
            }
        },
        {
            element: '#btnInutilizar',
            popover: {
                title: 'Botão Inutilizar',
                description: 'Clique nesse botão para inutilizar uma nota fiscal.',
                position: 'bottom'
            }
        },
        {
            element: '#tabelaNotas_wrapper',
            popover: {
                title: 'Notas Fiscais',
                description: 'Aqui ficam as notas fiscais filtradas.',
                position: 'top'
            }
        },
        {
            element: '#dadosnota',
            popover: {
                title: 'Dados da Nota',
                description: 'Aqui ficam os dados da nota que está selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnGerar',
            popover: {
                title: 'Botão Gerar',
                description: 'Clique aqui para gerar a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnCancelar',
            popover: {
                title: 'Botão Cancelar',
                description: 'Clique aqui para cancelar a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnExcluir',
            popover: {
                title: 'Botão Excluir',
                description: 'Clique aqui para excluir a nota fiscal selecionada.',
                position: 'top'
            }
        },
        {
            element: '#btnConsultar',
            popover: {
                title: 'Botão Consultar',
                description: 'Clique aqui para consultar a nota fiscal selecionada.',
                position: 'top'
            }
        }

        ]);
        driver.start();
        driver.getHighlightedElement();
    });
});


$(document).ready(async function () {
    const gerarVarios = localStorage.getItem('@nfce.permiteGerarMaisDeUmaNFCE') != null &&
        localStorage.getItem('@nfce.permiteGerarMaisDeUmaNFCE') != 'false';

    if (gerarVarios) {
        $('#checkPermiteGerarMaisDeUmaNFCE').prop('checked', true)
        $('#mostrarCheckTodos').removeClass('d-none')
            .addClass('d-inline');
    }

    await setarDataAtual('txtDataDe');
    await setarDataAtual('txtDataAte');
    const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2);
    const bloqNatureza = await CopiaParametro('FATURAMENTO', 13) == '1';
    const pedeSenhaCancelaNota = await CopiaParametro("FATURAMENTO", 8);

    const verificaKubernetes = await verificaSisplanSaas();
    const usuarioSisplan = getCookie("cod_usuario") == "0000"
    if ((verificaKubernetes) && (usuarioSisplan)) {
        $('#btnUploadXML').removeClass('d-none');
    }

    $("#fileXml").change(async function (event) {
        event.preventDefault();
        const tr = $('#tabelaNotas tr.selected')[0];
        if (tr == undefined) {
            msgAlerta('Selecione uma nota para importar o XML.');
            return;
        }
        const data = $('#tabelaNotas').DataTable().row($(tr)).data();
        let readXml = null;
        let selectedFile = document.getElementById("fileXml").files[0];
        const reader = new FileReader();

        reader.onload = async function (e) {
            const xmlString = e.target.result;

            const x2js = new X2JS();
            const jsonXml = x2js.xml_str2json(e.target.result);
            let nProt = '';
            let chNFe = '';

            if (jsonXml) {
                if (jsonXml.retArquivoXML) {
                    nProt = jsonXml.retArquivoXML.proc.nfeProc.protNFe.infProt.nProt
                    chNFe = jsonXml.retArquivoXML.proc.nfeProc.protNFe.infProt.chNFe
                } else {
                    nProt = jsonXml.nfeProc.protNFe.infProt.nProt
                    chNFe = jsonXml.nfeProc.protNFe.infProt.chNFe
                }
                const response = await requisicao(
                    'POST',
                    '/sisplan/funcoes/v1/importaxmlnfce?',
                    `FATURA_NFCE=${data.FATURA}&CHAVE_NFCE=${chNFe}&PROTOCOLO_NFCE=${nProt}&NOME_ARQUIVO=${selectedFile.name}`,
                    xmlString
                );

                if (response.status === 200) {
                    toastr.success(
                        'Feito o Upload do arquivo XML com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                    return;
                }

            }
        };
        reader.readAsText(selectedFile);
        $('#fileXml').val(null)
    })

    $('input[name=rg_status]:checked').on('change', function () {
        $('#btn-consultar').trigger('click');
    });
    $('input[name=rg_protocolo]:checked').on('change', function () {
        $('#btn-consultar').trigger('click');
    });

    $('#checkPermiteGerarMaisDeUmaNFCE').on('change', function () {
        const selecionado = $(this).prop('checked');
        localStorage.setItem('@nfce.permiteGerarMaisDeUmaNFCE', selecionado);
        window.location.reload();
    });

    $('#tabelaNotas').DataTable({
        paging: true,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        key: true,
    });

    $('#checkTodosItens').on('change', function () {
        $('.campoSel').prop('checked', $('#checkTodosItens').prop('checked'));
        if ($('#checkTodosItens').prop('checked')) {
            $('.campoSel').addClass('selecionado');
        } else {
            $('.campoSel').removeClass('selecionado');
        }
        $('.campoSel').trigger('change');
        $('#tabelaNotas tr').removeClass('selected');
        $('.campoSel').toArray().forEach(comp => {
            const linhaAtual = $(comp).closest('tr');
            if (!linhaAtual.hasClass('selected') && $('#checkTodosItens').prop('checked')) {
                linhaAtual.addClass('selected');
            } else {
                linhaAtual.removeClass('selected');
            }
        });
    });

    $('#tabelaItens').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
    });

    async function buscaNotas(iImpresso, iProtocolo, iTipoTransmissao) {
        let sDataIni = `'${$('#txtDataDe').val()}'`;
        let sDataFim = `'${$('#txtDataAte').val()}'`;
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        let impresso = '';
        let protocolo = '';
        let tipoTransmissao = '';
        let sCodCli = pegaChave('#txtCliente');
        if (sCodCli != '') {
            sCodCli = ` and nota_nfce.codcli = '${sCodCli}'`;
        }
        let sFatura = pegaChave('#txtNota');
        if (sFatura != '') {
            sFatura = ` and nota_nfce.fatura = '${sFatura}'`;
        }
        let sCodven = pegaChave('#txtVenda');
        if (sCodven != '') {
            sCodven = ` and nota_nfce.codven = ${sCodven}`;
        }
        switch (iImpresso) {
            case '1':
                {
                    impresso = 'S';
                    break;
                }
            case '2':
                {
                    impresso = 'N';
                    break;
                }
            case '3':
                {
                    impresso = 'C';
                    break;
                }
            case '4':
                {
                    impresso = 'D';
                    break;
                }
            default:
                impresso = '';
                break;
        }

        switch (iProtocolo) {
            case '1':
                {
                    protocolo = "and ((NOTA_NFCE.PROTOCOLO_NFCE IS NOT NULL) AND (NOTA_NFCE.PROTOCOLO_NFCE <> ''))";
                    break;
                }
            case '2':
                {
                    protocolo = "and ((NOTA_NFCE.PROTOCOLO_NFCE IS NULL) OR (NOTA_NFCE.PROTOCOLO_NFCE = ''))";
                    break;
                }
            default:
                protocolo = '';
                break;
        }

        switch (iTipoTransmissao) {
            case '1':
                {
                    tipoTransmissao = "and ((NOTA_NFCE.CHAVE_OFFLINE IS NULL) OR (NOTA_NFCE.CHAVE_OFFLINE = ''))";
                    break;
                }
            case '2':
                {
                    tipoTransmissao = "and ((NOTA_NFCE.CHAVE_OFFLINE IS NOT NULL) AND (NOTA_NFCE.CHAVE_OFFLINE <> ''))";
                    break;
                }
            default:
                tipoTransmissao = '';
                break;
        }

        try {
            if (impresso != '') {
                impresso = `and nota_nfce.impresso = '${impresso}'`;
            }
            const camposSelect = `["nota_nfce.fatura", "nota_nfce.serie", "nota_nfce.dt_emissao", "nota_nfce.codcli", "entidade.nome", "nota_nfce.valor", "nota_nfce.codven", "nota_nfce.chave_nfce", "nota_nfce.protocolo_nfce", "nota_nfce.emissao_nfce", "nota_nfce.recibo_nfce", "nota_nfce.impresso", "nota_nfce.chave_offline", "nota_nfce.operacao", "oper_fiscal.descricao desc_operacao", ` +
                `"(SELECT MAX(NOTA_NFE2.FATURA) FATURA FROM NOTA_REF_001 NOTA_REF INNER JOIN NOTA_001 NOTA_NFE2 ON NOTA_REF.NOTA = NOTA_NFE2.FATURA  AND NOTA_NFE2.SERIE = NOTA_REF.SERIE AND NOTA_NFE2.IMPRESSO <> 'C' LEFT JOIN NATUREZA_001 NATUREZA ON NATUREZA.NATUREZA = NOTA_NFE2.NATUREZA WHERE NOTA_REF.EMP_ID = ${getCookie('emp_id')} AND NOTA_REF.NOTA_REF = NOTA_NFCE.FATURA AND NATUREZA.TIPO = 'D') NOTA_EST "]`;

            let response = await requisicao('GET', url, `JSON={ "tabela":"nota_nfce", "camposSelect": ${camposSelect}, "leftjoin": [{"tabela":"entidade", "condicao":"entidade.codcli = nota_nfce.codcli"}, {"tabela":"oper_fiscal", "condicao":"nota_nfce.operacao = oper_fiscal.codigo"}], "where": ["nota_nfce.emp_id = ${getCookie('emp_id')} and (dt_emissao >= ${sDataIni} and dt_emissao <= ${sDataFim}) ${impresso} ${protocolo} ${tipoTransmissao} ${sFatura} ${sCodCli} ${sCodven}"],  "orderby": ["nota_nfce.fatura desc"]}`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as notas fiscais');
        }

    }
    async function RetornaSerieNFCE() {
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
            let response = await requisicao('GET', url, `JSON={ "tabela":"empresa", "camposSelect":["emp_serienfce"], "where": ["emp_id = ${getCookie('emp_id')}"] }`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            let serie = '';
            if (jsonStr.RESULT[0][0].EMP_SERIENFCE != '') {
                serie = jsonStr.RESULT[0][0].EMP_SERIENFCE;
            } else {
                serie = '1';
            }
            return serie;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados do produto.');
        }
    }

    async function buscaItens(sFatura, sSerie) {
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
            const empId = getCookie('emp_id');
            let response = await requisicao('GET', url, `JSON={ "tabela":"notaiten_nfce", 
                "camposSelect":[ "notaiten_nfce.codigo", "notaiten_nfce.descricao", "notaiten_nfce.cor", "cadcor.descricao desc_cor", "notaiten_nfce.qualidade", "notaiten_nfce.tamanho", "notaiten_nfce.qtde", "notaiten_nfce.preco", "notaiten_nfce.valor", "notaiten_nfce.desconto", "(notaiten_nfce.valor - notaiten_nfce.desconto) valor_liquido", "notaiten_nfce.natureza", "notaiten_nfce.ordem"], "leftjoin": [{"tabela":"cadcor", "condicao":"cadcor.cor = notaiten_nfce.cor"}], "innerJoin": [{"tabela":"nota_nfce", "condicao":"nota_nfce.fatura = notaiten_nfce.fatura and nota_nfce.emp_id = notaiten_nfce.emp_id"}], "where": ["notaiten_nfce.fatura = '${sFatura}' and notaiten_nfce.serie = '${sSerie}' and notaiten_nfce.emp_id = ${empId}"] }`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as notas fiscais');
        }
    }

    function retornaBotaoOpcoes(data, status, nota_dev) {
        let corFundo = '';

        if (nota_dev != '') {
            corFundo = '#fbb728';
        } else if (status == 'S') {
            corFundo = '#3CB371';
        } else if (status == 'N') {
            corFundo = 'var(--hover-color)';
        } else if (status == 'D') {
            corFundo = '#BC8F8F';
        } else if (status == 'C') {
            corFundo = '#fd6f53';
        }


        return `<div style="text-align:center;"> ` +
            `   <div class="dropdown"> ` +
            `    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" +
            ${corFundo != '' ? `style="background-color: ${corFundo} !important; border-color: ${corFundo} !important; color: #fff"` : ''}> ` +
            `    ${data} ` +
            `    </button> ` +
            `    <div class="dropdown-menu"> ` +
            `    <a id="btn-mostrar-itens" class="dropdown-item" href="">Mostrar Itens</a>` +
            `    </div>` +
            `  </div>` +
            `</div>`;
    }

    $('#btn-cliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome", "fantasia", "cnpj" ], "where": null}', 'Pesquisa Cliente', 'entidade');
    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
    $('#btn-limpa-cliente').on('click', function () {
        $('#txtCliente').val('');
    });

    $('#btn-venda').pesquisa('#txtVenda', 'CODVEN', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "ENTIDADE.NOME" ], "leftJoin": [{ "tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = VENDA.CODCLI" }], "where": ["venda.emp_id = ${getCookie('emp_id')}"]}`, 'Pesquisa Vendas', 'VENDA');
    $('#txtVenda').autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "ENTIDADE.NOME DESCRICAO" ], "leftJoin": [{ "tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = VENDA.CODCLI" }], "where": ["venda.emp_id = ${getCookie('emp_id')}"]}`);
    $('#btn-limpa-venda').on('click', function () {
        $('#txtVenda').val('');
    });

    $('#btn-nota').pesquisa('#txtNota', 'FATURA', 'VALOR', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"nota_nfce", "camposSelect":[ "fatura", "dt_emissao", "valor" ], "where": ["emp_id = ${getCookie('emp_id')}"]}`, 'Pesquisa Notas', 'nota_nfce');
    $('#txtNota').autocompleta(3, `JSON={ "tabela":"NOTA_NFCE", "camposSelect":["FATURA CHAVE", "VALOR DESCRICAO"], "where": ["emp_id = ${getCookie('emp_id')}"] }`);
    $('#btn-limpa-nota').on('click', function () {
        $('#txtNota').val('');
    });

    retornaHintRelatorio('btnImprimir', 'NFCE')

    async function inutilizaArrayNotas() {
        let faturasSucesso = '';
        let faturasSemSucesso = 'Seguintes faturas tiveram problema ao serem inutilizadas:';

        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        const data = $('#tabelaNotasInutilizacao').DataTable().rows('.selected').data().toArray();

        for (let index = 0; index < data.length; index++) {
            const item = data[index];

            let nfIni = item.FATURA;
            let nfFim = item.FATURA;

            if (item.FATURA.split(' [...] ').length > 1) {
                nfIni = item.FATURA.split(' [...] ')[0];
                nfFim = item.FATURA.split(' [...] ')[1];
            };

            try {
                const response = await requisicao(
                    'PUT',
                    '/Sisplan/NFCE/v1/InutilizarNFCE?',
                    `SERIE=${item.SERIE}&INICIO=${nfIni}&FIM=${nfFim}&JUSTIFICATIVA=${pegaValor('#txtJustificativa')}`,
                    null
                );

                if (!response) {
                    msgErro('Erro ao inutilizar fatura ' + item.FATURA);
                }
                if (response.status != 200) {
                    const jsonStr = await response.json();
                    faturasSemSucesso += '\n' + item.FATURA + ' - ' + jsonStr.mensagem;
                } else {
                    if (faturasSucesso == '') {
                        faturasSucesso += item.FATURA;
                    } else {
                        faturasSucesso += ', ' + item.FATURA;
                    }
                }
            } catch (error) {
                console.error(error);
            }
        }

        if (faturasSemSucesso.length > 57) {
            msgAlerta(faturasSemSucesso);
            return;
        }

        msgSucesso('Faturas ' + faturasSucesso + ' inutilizadas com sucesso.');
    }

    async function carregaNotasPendInutilizacao() {
        try {
            const serie = pegaValor('#txtNotaSerie');

            if (serie == '') {
                msgAlerta('Necessário preencher série para carregar notas pendentes de inutilização.');
                return;
            }

            const response = await requisicao('GET', '/sisplan/nfce/v1/buscapendinutilizacao?', `SERIE=${serie}`, null);

            if (!response) {
                return;
            }

            const notas = await response.text();

            if (response.status != 200) {
                msgErro(jsonStr.mensagem)
                return;
            }

            if (notas == '') {
                msgAlerta('Não há notas pendentes de inutilização para a série ' + serie);
                return;
            }

            const listaNotas = notas.split(',');

            let dataSetCols = [
                {
                    'data': 'SEL',
                    'title': 'SEL'
                },
                {
                    'data': 'FATURA',
                    'title': 'Fatura'
                },
                {
                    'data': 'SERIE',
                    'title': 'Série'
                }
            ];

            const sDados = [];

            listaNotas.map(item => {
                sDados.push({
                    SEL: botaoSelecionarGrid(),
                    FATURA: item,
                    SERIE: serie
                });
            });

            criaDataTablePadrao('#tabelaNotasInutilizacao', false, false, false, false, true, false, '300px', sDados, dataSetCols);

            setTimeout(() => { $('#tabelaNotasInutilizacao').DataTable().columns.adjust().draw(false); }, 200);

        } catch (error) {
            console.error(error);
        }
    }

    $('#tabelaNotasInutilizacao').on('click', 'td', function () {
        selecionarLinhaTabela('#tabelaNotasInutilizacao', 'checkNotaInutil', this);
    });

    function botaoSelecionarGrid() {
        return '<div class="form-check">' +
            '<input type="checkbox" class="align-self-center checkNotaInutil" value"">' +
            '</div>';
    };

    $('#btnImprimir').on('click', async function () {
        const fatura = $('#txtNumeroNF').val();
        const serie = $('#txtSerieNF').val();
        const chave = $('#txtChaveNF').val();
        const chaveOffline = $('#txtChaveOffline').val();

        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        if (fatura == '') {
            msgAlerta('Nenhuma nota selecionada, impossível continuar.');
            return;
        }

        if (chave === '' && chaveOffline === '') {
            msgAlerta('Impossível imprimir NFC-e não transmitida.');
            return;
        }

        const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

        let response = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTA_NFCE", "camposSelect":["CODVEN"], "where": ["FATURA = '${fatura}' AND SERIE = '${serie}' AND EMP_ID = ${getCookie("emp_id")}"] }`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }
        const codven = jsonStr.RESULT[0][0].CODVEN;

        const url = `/sisplan/nfce/v1/imprimirnfce?FATURA=${fatura}&SERIE=${serie}&CODVEN=${codven}`;
        try {
            $.LoadingOverlay("show");
            const bImprimeAutomatico = await verificaImprimirAutomatico('NFCE');
            const arquivo = await GeraRelatorio(`${url}&`, 'GET', 600000, false, 'NFCE');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnWhatsApp').on('click', async function () {
        const fatura = $('#txtNumeroNF').val();
        const serie = $('#txtSerieNF').val();
        const chave = $('#txtChaveNF').val();
        const chaveOffline = $('#txtChaveOffline').val();

        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        if (fatura == '') {
            msgAlerta('Nenhuma nota selecionada, impossível continuar.');
            return;
        }

        if (chave === '' && chaveOffline === '') {
            msgAlerta('Impossível enviar WhatsApp de NFC-e não transmitida.');
            return;
        }

        let tr = $('#tabelaNotas tr.selected')[0];
        let data = $('#tabelaNotas').DataTable().row($(tr)).data();

        const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

        let response = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTA_NFCE", "camposSelect":["CODVEN"], "where": ["FATURA = '${fatura}'"] }`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }
        const codven = jsonStr.RESULT[0][0].CODVEN;

        await enviaWhatsNFCE(fatura, serie, data.CODCLI, data.NOME, codven);
    });

    async function caixaFechado(fatura, serie) {
        try {
            const dadosSelect = {
                tabela: 'nota_nfce',
                camposSelect: ['1'],
                innerJoin: [
                    { "tabela": "venda", "condicao": "nota_nfce.codven = venda.codven" },
                    { "tabela": "venda_fechamento", "condicao": "venda_fechamento.dt_fechamento = nota_nfce.dt_emissao and venda_fechamento.nrcaixa = venda.nrcaixa and venda_fechamento.emp_id = nota_nfce.emp_id" }
                ],
                where: [`nota_nfce.emp_id = ${getCookie('emp_id')} and nota_nfce.fatura = '${fatura}' and nota_nfce.serie = '${serie}'`],
            };

            const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

            if (!retornoSelect) {
                return false;
            }

            return (retornoSelect.length > 0);
        } catch {
            return false;
        }
    };

    $('#btnCancelar').on('click', async function () {
        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        var tr = $('#tabelaNotas tr.selected')[0];
        var data = $('#tabelaNotas').DataTable().row($(tr)).data();

        if (await caixaFechado(data.FATURA, data.SERIE)) {
            msgAlerta('Caixa do dia ' + formataDataBonita(data.DT_EMISSAO) + ' fechado, impossível cancelar a nota. Necessário reabrir para realizar o cancelamento.');
            return;
        }

        const inicio = new Date(data.DT_EMISSAO.split('/')[2] + '-' + data.DT_EMISSAO.split('/')[1] + '-' + data.DT_EMISSAO.split('/')[0])
        const diferencaEmDias = Math.ceil(Math.abs(new Date() - inicio) / (1000 * 60 * 60 * 24)) - 1;

        const senhaSupervisor24h = pedeSenhaCancelaNota == 1;
        const senhaSupervisor48h = pedeSenhaCancelaNota == 2;
        const senhaMaster24h = pedeSenhaCancelaNota == 3;
        const senhaMaster48h = pedeSenhaCancelaNota == 4;


        if ((pedeSenhaCancelaNota == '5') && (data.PROTOCOLO_NFCE != '')) {
            await senhaSupervisor('Necessário informar senha de usuário supervisor/master para cancelar NFC-e.', async () => {
                await cancelarNFCE();
            }, '', false, undefined, undefined, undefined, false, 'IMPRESSAONFCE', data.FATURA, data.CODCLI, parseFloat(data.VALOR) || 0);
        } else if ((pedeSenhaCancelaNota == '6') && (data.PROTOCOLO_NFCE != '')) {
            await senhaSupervisor('Necessário informar senha de usuário Master para cancelar NFC-e.', async () => {
                await cancelarNFCE();
            }, '', false, undefined, undefined, undefined, true, 'IMPRESSAONFCE', data.FATURA, data.CODCLI, parseFloat(data.VALOR) || 0);
        } else if ((pedeSenhaCancelaNota != '0') && (data.PROTOCOLO_NFCE != '') && (diferencaEmDias > 0)) {
            if (senhaSupervisor24h) {
                await senhaSupervisor('NFC-e gerada há mais de 24h, necessário informar senha de supervisor/master.', async () => {
                    await cancelarNFCE();
                }, '', false, undefined, undefined, undefined, false, 'IMPRESSAONFCE', data.FATURA, data.CODCLI, parseFloat(data.VALOR) || 0);
            } else if ((senhaSupervisor48h) && diferencaEmDias >= 2) {
                await senhaSupervisor('NFC-e gerada há mais de 48h, necessário informar senha de supervisor/master.', async () => {
                    await cancelarNFCE();
                }, '', false, undefined, undefined, undefined, false, 'IMPRESSAONFCE', data.FATURA, data.CODCLI, parseFloat(data.VALOR) || 0);
            } else if (senhaMaster24h) {
                await senhaSupervisor('NFC-e gerada há mais de 24h, necessário informar senha de usuário Master.', async () => {
                    await cancelarNFCE();
                }, '', false, undefined, undefined, undefined, true, 'IMPRESSAONFCE', data.FATURA, data.CODCLI, parseFloat(data.VALOR) || 0);
            } else if ((senhaMaster48h) && diferencaEmDias >= 2) {
                await senhaSupervisor('NFC-e gerada há mais de 48h, necessário informar senha de usuário Master.', async () => {
                    await cancelarNFCE();
                }, '', false, undefined, undefined, undefined, true, 'IMPRESSAONFCE', data.FATURA, data.CODCLI, parseFloat(data.VALOR) || 0);
            }
        } else {
            await cancelarNFCE();
        }

    });

    async function cancelarNFCE() {
        let tr = $('#tabelaNotas tr.selected')[0];
        let data = $('#tabelaNotas').DataTable().row($(tr)).data();
        $('#txtCancFatura').val(data.FATURA);
        $('#txtCancSerie').val(data.SERIE);
        if (data.IMPRESSO == 'C') {
            msgAlerta('Esta nota fiscal já está cancelada. Impossível continuar.');
            return;
        }

        if (data.IMPRESSO == 'D') {
            msgAlerta('A NFe foi DENEGADA. Não pode ser cancelada no SEFAZ. Somente será cancelado as duplicatas, voltar o pedido e estoque se houver!');
        }
        $('#modal-cancelamento').modal('show');
    }

    $('#btn-confirmar-cancelamento').on('click', async function () {

        try {
            $.LoadingOverlay("show");
            const fatura = $('#txtCancFatura').val();
            const serie = $('#txtCancSerie').val();
            const justificativa = $('#txtCancJustificativa').val();
            let tr = $('#tabelaNotas tr.selected')[0];
            let data = $('#tabelaNotas').DataTable().row($(tr)).data();
            const chaveNfceCancA3 = data.CHAVE_NFCE;

            if (usaCertificadoA3 == '1' & (chaveNfceCancA3 != '')) {

                const infoEmpresaCancA3 = await retornaInformacaoEmpresa();

                const pesquisaXML = {
                    tabela: "XML_NOTAS",
                    camposSelect: [
                        "XML_NOTAS.ARQUIVO",
                    ],
                    where: [`XML_NOTAS.CHAVE_NFE = '${chaveNfceCancA3}' AND XML_NOTAS.TIPO = 'NFC'`]
                }

                const jsonStrPesquisaXML = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaXML));

                const xmlCanc = jsonStrPesquisaXML[0].ARQUIVO;

                //CONSULTA NA APILOCAL
                const responseApiLocalCancA3 = await requisicao_ecf('POST', '/nfce/consultar?', `CHAVE=${chaveNfceCancA3}`, JSON.stringify(infoEmpresaCancA3), 60000);

                if (responseApiLocalCancA3.status != 200) {
                    const msgErroCancA3 = await responseApiLocalCancA3.text();
                    msgErro(msgErroCancA3);
                    return;
                };

                const pesquisaLoteNFCE = {
                    tabela: "NOTA_NFCE",
                    camposSelect: [
                        "NOTA_NFCE.LOTE_NFCE, NOTA_NFCE.IMPRESSO, NOTA_NFCE.PROTOCOLO_NFCE",
                    ],
                    where: [`NOTA_NFCE.FATURA = '${fatura}' AND NOTA_NFCE.SERIE = '${serie}' AND NOTA_NFCE.CODVEN = ${data.CODVEN}`]
                };

                const jsonStrPesquisaLote = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaLoteNFCE));


                const usuario = getCookie('usuario');
                const empresa = getCookie('empresa');

                const responseApiLocalCancelamento = await requisicao_ecf('POST',
                    '/nfce/cancelar?',
                    `FATURA=${fatura}&SERIE=${serie}&JUSTIFICATIVA=${justificativa}&IMPRESSO=${jsonStrPesquisaLote[0].IMPRESSO}&CHAVE_NFCE=${chaveNfceCancA3}&LOTE_NFCE=${jsonStrPesquisaLote[0].LOTE_NFCE}&INFEMPRESA=${JSON.stringify(infoEmpresaCancA3)}&PROTOCOLO_NFCE=${jsonStrPesquisaLote[0].PROTOCOLO_NFCE}`,
                    xmlCanc, 120000)

                if (responseApiLocalCancelamento.status != 200) {
                    const mensagemErro = await responseApiLocalCancelamento.text();
                    msgErro(mensagemErro);
                    return;
                }

                const jsonApiLocal = await responseApiLocalCancelamento.json();

                const responseApiWebCanc = await requisicao('POST',
                    '/Sisplan/NFCE/v1/finalizacancelamento?',
                    `FATURA=${fatura}&SERIE=${serie}&EMPRESA=${empresa}&JUSTIFICATIVA=${justificativa}`,
                    jsonApiLocal.xml, 120000);

                const jsonApiWeb = await responseApiWebCanc.json()

                if (responseApiWebCanc.status != 200) {
                    msgErro(jsonApiWeb.mensagem);
                    return;
                }

                toastr.success(
                    'Cancelamento efetuado com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        $('#modal-cancelamento').modal('hide');
                        $('#btn-consultar').trigger('click');
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } else {

                const fatura = $('#txtCancFatura').val();
                const serie = $('#txtCancSerie').val();
                const justificativa = $('#txtCancJustificativa').val();
                let tr = $('#tabelaNotas tr.selected')[0];
                let data = $('#tabelaNotas').DataTable().row($(tr)).data();
                const url = '/Sisplan/NFCE/v1/CancelarNFCE?';
                let params = `SERIE=${serie}&FATURA=${fatura}&JUSTIFICATIVA=${justificativa}&CERTA3=${0}`;

                try {
                    let response = await requisicao('PUT', url, params, null, 120000);

                    if (!response) {
                        msgErro('Erro ao cancelar NFC-e');
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status == 502) {
                        await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
                    } else if (response.status != 200) {
                        msgErro(jsonStr.mensagem);
                        return;
                    }

                    toastr.success(
                        'Cancelamento efetuado com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            $('#modal-cancelamento').modal('hide');
                            $('#btn-consultar').trigger('click');
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } catch (error) {
                    console.error(error);
                }
            };
        } finally {
            $.LoadingOverlay("hide");
        };
    });

    const gerarNFCEVarios = async () => {
        const rotinaGeraVarios = async (sJustificativa = '') => {
            try {
                try {
                    $.LoadingOverlay("show");
                    const notasComErro = [];
                    const notasJaGeradas = [];
                    // const notas = $('#tabelaNotas tr.selected');
                    const currentPage = $('#tabelaNotas').DataTable().page();
                    let notas = [];
                    $('#tabelaNotas').DataTable().rows().every(function () {
                        // Se a linha está selecionada, adiciona ao array
                        if ($(this.node()).hasClass('selected')) {
                            notas.push(this.data());
                        }
                    });
                    $('#tabelaNotas').DataTable().page(currentPage).draw('page');
                    for (let i = 0; i < notas.length; i++) {
                        const nota = notas[i];
                        // const data = $('#tabelaNotas').DataTable().row($(nota)).data();
                        const fatura = nota.FATURA;
                        const serie = nota.SERIE;
                        const justificativa = sJustificativa;
                        const tipo = $('#tipo_transmissao').val();
                        const url = '/Sisplan/NFCE/v1/NFCE?';
                        if (nota.PROTOCOLO_NFCE != '') {
                            notasJaGeradas.push(fatura + ' ');
                        } else {
                            const params = `SERIE=${serie}&FATURA=${fatura}&JUSTIFICATIVA=${justificativa}&TIPO=${tipo}&CERTA3=${usaCertificadoA3}`;
                            const response = await requisicao('PUT', url, params, null, 120000);

                            const jsonStr = await response.json();

                            if (response.status == 502) {
                                await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
                            } else if (response.status != 200) {
                                msgErro(jsonStr.mensagem);
                                notasComErro.push(fatura + ' ');
                            }
                            if (usaCertificadoA3 == '1' && (response.status == 200)) {
                                const xml = jsonStr.mensagem;
                                const infoEmpresa = await retornaInformacaoEmpresa();

                                const responseLocal = await requisicao_ecf('POST', '/nfce/emitir?', `EMPRESA=${JSON.stringify(infoEmpresa)}`, xml, 120000);

                                if (responseLocal.status != 200) {
                                    const mensagemErro = await responseLocal.text();
                                    msgErro(mensagemErro);
                                    return;
                                }

                                const retornoNota = await responseLocal.json();

                                const reponseApiWeb = await requisicao(
                                    'POST',
                                    '/sisplan/nfce/v1/finalizanfce?',
                                    `FATURA=${fatura}&SERIE=${serie}&TIPO=${tipo}`,
                                    JSON.stringify(retornoNota),
                                    60000
                                );
                                if (!response) {
                                    return;
                                }
                                if (reponseApiWeb.status != 200) {
                                    const mensagemRetorno = await reponseApiWeb.json();
                                    msgErro(mensagemRetorno.mensagem);
                                    return;
                                };
                            }
                        }
                    }

                    if (notasJaGeradas.length > 0) {
                        toastr.error(
                            `Notas ${notasJaGeradas.toString()} já estão geradas, favor verificar.`,
                            'Atenção', {
                            toastClass: 'alert',
                            iconClasses: {
                                error: 'alert-error',
                                info: 'alert-info',
                                success: 'alert-success',
                                warning: 'alert-warning'
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                $('#btn-consultar').trigger('click');
                            }
                        }
                        ).css({
                            "margin-top": "20%",
                            "width": "500px",
                            "max-width": "500px"
                        });
                        return;
                    }

                    if (notasComErro.length > 0) {
                        toastr.error(
                            `Notas ${notasComErro.toString()} não geradas, favor verificar.`,
                            'Atenção', {
                            toastClass: 'alert',
                            iconClasses: {
                                error: 'alert-error',
                                info: 'alert-info',
                                success: 'alert-success',
                                warning: 'alert-warning'
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                $('#btn-consultar').trigger('click');
                            }
                        }
                        ).css({
                            "margin-top": "20%",
                            "width": "500px",
                            "max-width": "500px"
                        });
                        return;
                    }

                    toastr.success(
                        'NFCEs geradas com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            $('#btn-consultar').trigger('click');
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } finally {
                    $.LoadingOverlay("hide");
                }
            } catch (error) {
                console.error(error);
                msgErro('Erro ao gerar NFC-e');
            }
        }

        try {
            $('#btnGerar').attr('disabled', true);
            const tr = $('#tabelaNotas tr.selected')[0];
            if (tr === undefined) {
                msgAlerta('Selecione uma Nota para gerar.');
                return;
            }

            if ($('#tipo_transmissao').val() == '0') {
                await rotinaGeraVarios();
            } else {
                msgAlerta('Não é possível gerar mais de uma NFC-e off-line.');
                return;
            }
        } finally {
            $('#btnGerar').attr('disabled', false);
        }
    }

    async function retornaInformacaoEmpresa() {
        try {
            let url = `/sisplan/funcoes/v1/pesquisa?`;
            let response = await requisicao('GET', url, `JSON={ 
            "tabela":"empresa", 
            "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert", "emp_crt", "emp_cnpj", "emp_id"], 
            "where": ["emp_id = ${getCookie('emp_id')}"] 
          }`, null);
            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            return jsonStr.RESULT[0][0];
        } catch (error) {
            console.error(error);
            msgErro('Erro ao retornar dados da empresa, Erro: ');
        }
    }


    const rotinaGeraIndividual = async (sJustificativa = '') => {
        try {
            try {
                $.LoadingOverlay("show");
                let tr = $('#tabelaNotas tr.selected')[0];
                let data = $('#tabelaNotas').DataTable().row($(tr)).data();
                let fatura = data.FATURA;
                let serie = data.SERIE;
                let justificativa = sJustificativa;
                let tipo = $('#tipo_transmissao').val();
                let url = '/Sisplan/NFCE/v1/NFCE?';
                let params = `SERIE=${serie}&FATURA=${fatura}&JUSTIFICATIVA=${justificativa}&TIPO=${tipo}&CERTA3=${usaCertificadoA3}`;
                let response = await requisicao('PUT', url, params, null, 120000);


                let jsonStr = await response.json();

                if (response.status == 502) {
                    await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
                } else if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return;
                };

                if (usaCertificadoA3 == '1' && (response.status == 200)) {
                    const xml = jsonStr.mensagem;
                    const infoEmpresa = await retornaInformacaoEmpresa();

                    //transmite a nfce na apilocal
                    const responseLocal = await requisicao_ecf('POST', '/nfce/emitir?', `EMPRESA=${JSON.stringify(infoEmpresa)}`, xml, 120000);
                    if (responseLocal.status != 200) {
                        const mensagemErro = await responseLocal.text();
                        msgErro(mensagemErro);
                        return;
                    }

                    const retornoNota = await responseLocal.json();

                    // termina de transmitir na api web, da os updates etc
                    const reponseApiWeb = await requisicao(
                        'POST',
                        '/sisplan/nfce/v1/finalizanfce?',
                        `FATURA=${fatura}&SERIE=${serie}&TIPO=${tipo}`,
                        JSON.stringify(retornoNota),
                        60000
                    );
                    if (!response) {
                        return;
                    }
                    if (reponseApiWeb.status != 200) {
                        const mensagemRetorno = await reponseApiWeb.json();
                        msgErro(mensagemRetorno.mensagem);
                        return;
                    };
                }
                const urlPesquisa = `/sisplan/funcoes/v1/pesquisa?`;

                let responseCodven = await requisicao('GET', urlPesquisa, `JSON={ "tabela":"NOTA_NFCE", "camposSelect":["CODVEN"], "where": ["FATURA = '${fatura}' AND SERIE = '${serie}'"] }`, null);

                if (!responseCodven) {
                    return;
                }

                let jsonStrCodven = await responseCodven.json();
                if (responseCodven.status != 200) {
                    msgErro(jsonStrCodven.RESULT[0].mensagem);
                    return;
                }
                const codven = jsonStrCodven.RESULT[0][0].CODVEN;

                const urlImprimir = `/sisplan/nfce/v1/imprimirnfce?FATURA=${fatura}&SERIE=${serie}&CODVEN=${codven}`;
                try {
                    $.LoadingOverlay("show");
                    const bImprimeAutomatico = await verificaImprimirAutomatico('NFCE');
                    const arquivo = await GeraRelatorio(`${urlImprimir}&`, 'GET', 15000, false, 'NFCE');
                    if (arquivo != undefined) {
                        if (!bImprimeAutomatico) {
                            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                        }
                        await limparRelatorios();
                    }
                } finally {
                    $.LoadingOverlay("hide");
                }

                toastr.success(
                    'NFC-e gerada com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        $('#btn-consultar').trigger('click');
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            } finally {
                $.LoadingOverlay("hide");
            }
        } catch (error) {
            console.error(error);
            msgErro('Erro ao gerar NFC-e');
        }
    }

    const gerarNFCEIndividual = async (sJustificativa = '') => {
        try {
            $('#btnGerar').attr('disabled', true);
            const tr = $('#tabelaNotas tr.selected')[0];
            if (tr === undefined) {
                msgAlerta('Selecione uma Nota para gerar.');
                return;
            }

            const data = $('#tabelaNotas').DataTable().row($(tr)).data();
            const today = new Date();
            const dy = String(today.getDate()).padStart(2, "0");
            const mt = String(today.getMonth() + 1).padStart(2, "0");
            const yr = today.getFullYear();

            if (data.PROTOCOLO_NFCE != '') {
                msgAlerta('NFC-e já gerada, verifique.');
                return;
            }

            if ($('#tipo_transmissao').val() == '0') {
                if (data.DT_EMISSAO.substr(0, 10) == `${yr}-${mt}-${dy}`) {
                    await rotinaGeraIndividual(sJustificativa);
                } else {
                    msgAlerta('Data da NFC-e diferente da data atual, deseja prosseguir com o processo?', async () => { await rotinaGeraIndividual(sJustificativa); });
                }
            } else {
                if ($('.campoSel:checked').length > 1) {
                    msgAlerta('Não é possível gerar mais de uma NFC-e off-line.');
                    return;
                }

                $('#txtJustificativaOffline').val('');
                $('#modal-gerar-offline').modal('show');
            }
        } finally {
            $('#btnGerar').attr('disabled', false);
        }
    }


    $('#btnGerar').on('click', async function () {
        const currentPage = $('#tabelaNotas').DataTable().page();
        let notas = [];
        $('#tabelaNotas').DataTable().rows().every(function () {
            if ($(this.node()).hasClass('selected')) {
                notas.push(this.data());
            }
        });

        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        $('#tabelaNotas').DataTable().page(currentPage).draw('page');
        const maisDeUmaNotaSelecionada = notas.length > 1;
        if (maisDeUmaNotaSelecionada) {
            await gerarNFCEVarios();
        } else {
            await gerarNFCEIndividual();
        }
    });

    $('#btn-gerar-offline').on('click', async function () {
        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        if ($('#txtJustificativaOffline').val() == '') {
            msgErro('Justificativa não pode estar em branco.');
            return;
        }
        if ($('#txtJustificativaOffline').val().length < 15) {
            msgErro('Justificativa deve ter no mínimo 15 caracteres.');
            return;
        }
        if ($('#txtJustificativaOffline').val().length > 100) {
            msgErro('Justificativa deve ter no máximo 100 caracteres.');
            return;
        }

        await rotinaGeraIndividual($('#txtJustificativaOffline').val());
        $('#modal-gerar-offline').modal('hide');
    });


    $('#btn-confirmar-inutilizacao').on('click', async function () {
        try {
            // validar os campos de serie, nota inicial final..
            $.LoadingOverlay("show");

            const url = '/Sisplan/NFCE/v1/InutilizarNFCE?';
            let serie = $('#txtNotaSerie').val();
            let inicio = $('#txtNotaIni').val();
            let final = $('#txtNotaFim').val();
            let justificativa = $('#txtJustificativa').val();
            let params = `SERIE=${serie}&INICIO=${inicio}&FIM=${final}&JUSTIFICATIVA=${justificativa}`;

            try {
                if ($('#tabelaNotasInutilizacao').DataTable().rows('.selected').data().length > 0) {
                    await inutilizaArrayNotas();
                } else {
                    let response = await requisicao('PUT', url, params, null);

                    if (!response) {
                        msgErro('Erro ao Inutilizar NFCE');
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.mensagem);
                        return;
                    }

                    toastr.success(
                        'Inutilização efetuada com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            $('#modal-inutilizar').modal('hide');
                            $('#btn-consultar').trigger('click');
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnExcluir').on('click', async function () {
        try {
            try {
                if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

                if ($('#txtProtocoloNF').val() != '') {
                    msgAlerta('Nota não pode ser excluída, pois consta no SEFAZ como autorizada ou cancelada.');
                    return;
                }
                $.LoadingOverlay("show");

                let tr = $('#tabelaNotas tr.selected')[0];
                let data = $('#tabelaNotas').DataTable().row($(tr)).data();
                if (data.IMPRESSO != 'C') {
                    msgAlerta('Nota precisa ser cancelada primeiro.');
                    return;
                }

                msgAguardaConfirmacao(
                    'Tem certeza que deseja excluir a NFC-e? Esta ação é irreversível.',
                    async () => { await excluirNfce(data) },
                    () => { }
                );

            } finally {
                $.LoadingOverlay("hide");
            }
        } catch (error) {
            console.error(error);
            msgErro('Erro ao excluir NFC-e');
        }
    });

    async function excluirNfce(data) {
        const url = '/Sisplan/NFCE/v1/NFCE?';
        let response = await requisicao('DELETE', url, `FATURA=${data.FATURA}&SERIE=${data.SERIE}&TIPO=0`, null);

        if (!response) {
            msgErro('Erro ao Excluir NFCE');
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        toastr.success(
            'Exclusão efetuada com sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                $('#btn-consultar').trigger('click');
            }
        }
        ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
        });
    }

    $('#btnConsultar').on('click', async function () {
        const fatura = $('#txtNumeroNF').val();
        const serie = $('#txtSerieNF').val();
        const chave = $('#txtChaveNF').val();
        const protocolo = $('#txtProtocoloNF').val();
        const url = `/sisplan/nfce/v1/consultanfce?`;

        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        if (fatura == '') {
            msgAlerta('Favor selecionar uma nota para consultar.');
            return;
        }
        if (chave == '') {
            msgAlerta('Nota não gerada, impossível consultar.');
            return;
        }

        try {
            if (usaCertificadoA3 == '1') {
                const infoEmpresaA3 = await retornaInformacaoEmpresa();

                const responseApiLocal = await requisicao_ecf('POST', '/nfce/consultar?', `CHAVE=${chave}`, JSON.stringify(infoEmpresaA3), null)

                if (!responseApiLocal) {
                    return;
                };
                const jsonStrApiLocal = await responseApiLocal.json();

                if (responseApiLocal.status != 200) {
                    msgErro(jsonStrApiLocal.mensagem);
                    return;
                };

                const protocoloA3Consulta = jsonStrApiLocal.protocolo;
                const statusA3Consulta = jsonStrApiLocal.cStat;
                const dtrecebimentoA3Consulta = jsonStrApiLocal.dhRecbto;
                const motivoA3Consulta = jsonStrApiLocal.xMotivo;

                const responseA3 = await requisicao('POST', url, `FATURA=${fatura}&SERIE=${serie}&CHAVE=${chave}&PROTOCOLO=${protocoloA3Consulta}&STATUS=${statusA3Consulta}&MOTIVO=${motivoA3Consulta}&DTRECEBIMENTO=${dtrecebimentoA3Consulta}&CERTA3=${usaCertificadoA3}`, null);

                if (!responseA3) {
                    return;
                };

                const jsonStrA3 = await responseA3.json();

                if (responseA3.status != 200) {
                    msgErro(jsonStrA3.mensagem);
                    return;
                };

                await msgAlerta(jsonStrA3.mensagem);

                $('#btn-consultar').trigger('click');
            } else {
                const response = await requisicao('POST', url, `FATURA=${fatura}&SERIE=${serie}&CHAVE=${chave}&PROTOCOLO=${protocolo}&CERTA3=${usaCertificadoA3}`, null);

                if (!response) {
                    return;
                };

                const jsonStr = await response.json();

                if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return;
                };

                await msgAlerta(jsonStr.mensagem);

                $('#btn-consultar').trigger('click');
            }
        } catch (error) {
            console.error(error);
        }
    });

    $('#confirmar_dados').on('click', async function () {
        try {
            try {
                $.LoadingOverlay("show");
                if ($('#txtProtocoloNF').val() == '') {
                    let arrItens = [];
                    for (let index = 0; index < $('#tabelaItens').DataTable().rows().count(); index++) {
                        const dados = $('#tabelaItens').DataTable().row(index).data();
                        const natureza = $($('.campoNatureza')[index]).val();
                        const item = {};
                        item.FATURA = $('#txtNotaItens').val();
                        item.SERIE = $('#txtSerieItens').val();
                        item.CODIGO = dados.CODIGO;
                        item.COR = dados.COR;
                        item.TAM = dados.TAMANHO;
                        item.ORDEM = dados.ORDEM;
                        item.NATUREZA = natureza;
                        arrItens.push(item);
                    }
                    const url = '/Sisplan/NFCE/v1/AlterarNaturezaNFCE?';
                    let response = await requisicao('PUT', url, `JSON=${encodeURIComponent(JSON.stringify(arrItens))}`, null);

                    if (!response) {
                        msgErro('Erro ao alterar Naturezas');
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    toastr.success(
                        'Alteração efetuada com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            $('#modal-itens').modal('hide');
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } else {
                    $('#modal-itens').modal('hide');
                }
            } finally {
                $.LoadingOverlay("hide");
            }

        } catch (error) {
            console.error(error);
        }
    });

    $('#btnInutilizar').on('click', async function () {
        let serie = await RetornaSerieNFCE();
        $('#txtNotaSerie').val(serie);
        $('#modal-inutilizar').modal('show');

        await carregaNotasPendInutilizacao();
    });

    function nomeColuna(title) {
        const nomes = {
            'FATURA': 'Fatura',
            'SERIE': 'Série',
            'DT_EMISSAO': 'Data Emissão',
            'CODCLI': 'Codcli',
            'NOME': 'Nome',
            'VALOR': 'Valor',
            'CODVEN': 'Código Venda',
            'OPERACAO': 'Operação',
            'DESC_OPERACAO': 'Desc. Operação'
        };
        return nomes[title] ?? title;
    }

    $('#btn-consultar').on('click', async function () {
        try {
            $.LoadingOverlay("show");
            $('#tabelaNotas').DataTable().clear().draw(false);
            $('#checkTodosItens').prop('checked', false);
            // $('#btn-filtros').trigger('click');
            let dados = await buscaNotas($('input[name=rg_status]:checked').val(), $('input[name=rg_protocolo]:checked').val(), $('input[name=rg_tipo_transmissao]:checked').val());
            let dataSetCols = [];

            if (!$.isEmptyObject(dados.RESULT[0][0])) {
                let keys = Object.keys(dados.RESULT[0][0]);
                const colunaData = gerarVarios ? 3 : 2;
                const colunasInvisiveis = gerarVarios ? [8, 9, 10, 11, 12, 13, 16] : [7, 8, 9, 10, 11, 12, 15];
                const colunaValor = gerarVarios ? 6 : 5;
                const colunaBotao = gerarVarios ? 1 : 0;

                if (gerarVarios) {
                    dataSetCols.push({
                        'title': 'SEL',
                        'data': 'SEL'
                    });
                }

                // eslint-disable-next-line guard-for-in, no-restricted-syntax
                for (let k in keys) {
                    dataSetCols.push({
                        'title': nomeColuna(keys[k]),
                        'data': keys[k]
                    });
                }


                if (gerarVarios) {
                    dataSetCols[0].render = function (data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="check${meta.row}" class="campoSel">
                        <label for="check${meta.row}"></label>
                        </div>`
                    }
                }

                dataSetCols[colunaData].type = 'date-br';
                dataSetCols[colunaData].render = function (data) {
                    x = data.slice(0, 10).split('-');
                    return `${x[2]}/${x[1]}/${x[0]}`;
                };

                $('#tabelaNotas').DataTable({
                    paging: true,
                    filter: true,
                    info: true,
                    order: true,
                    destroy: true,
                    select: true,
                    keys: true,
                    "data": dados.RESULT[0],
                    "columns": dataSetCols,
                    "columnDefs": [
                        {
                            "targets": colunasInvisiveis,
                            "visible": false
                        },
                        {
                            "render": function (data) {
                                return parseFloat(data).toLocaleString('pt-BR', {
                                    maximumFractionDigits: 2,
                                    minimumFractionDigits: 2
                                });
                            },
                            "targets": [colunaValor],
                            "className": 'pr-4 text-right'
                        },
                        {
                            targets: [colunaBotao], render(data, type, row) {
                                return retornaBotaoOpcoes(data, row.IMPRESSO, row.NOTA_EST);
                            },
                        },
                    ]
                });

            }

            const adicionaFuncaoSelecionar = () => {
                $('.campoSel').off();
                $('.campoSel').on('change', function () {
                    const atualEstaSelecionado = $(this).prop('checked');
                    const peloMenosUmSelecionado = $('.campoSel:checked').length > 1;
                    const nenhumSelecionado = $('.campoSel:checked').length == 0;
                    const data = $('#tabelaNotas').DataTable().row($(this).closest('tr')).data();
                    const tr = $(this).closest('tr');
                    if (!tr.hasClass('selected')) {
                        tr.addClass('selected');
                    } else {
                        tr.removeClass('selected');
                    }

                    if (atualEstaSelecionado) {
                        $('#txtNumeroNF').val(data.FATURA);
                        $('#txtSerieNF').val(data.SERIE);
                        $('#txtEmissaoNF').val(data.EMISSAO_NFCE);
                        $('#txtProtocoloNF').val(data.PROTOCOLO_NFCE);
                        $('#txtReciboNF').val(data.RECIBO_NFCE);
                        $('#txtChaveNF').val(data.CHAVE_NFCE);
                        $('#txtChaveOffline').val(data.CHAVE_OFFLINE);
                    } else if (nenhumSelecionado) {
                        $('#txtNumeroNF').val('');
                        $('#txtSerieNF').val('');
                        $('#txtEmissaoNF').val('');
                        $('#txtProtocoloNF').val('');
                        $('#txtReciboNF').val('');
                        $('#txtChaveNF').val('');
                        $('#txtChaveOffline').val('');
                    }
                    else {
                        const ultimaLinhaEncontrada = $($('.campoSel:checked')[$('.campoSel:checked').length - 1]).closest('tr');
                        const dataUltimaLinhaEncontrada = $('#tabelaNotas').DataTable().row(ultimaLinhaEncontrada).data();
                        $('#txtNumeroNF').val(dataUltimaLinhaEncontrada.FATURA);
                        $('#txtSerieNF').val(dataUltimaLinhaEncontrada.SERIE);
                        $('#txtEmissaoNF').val(dataUltimaLinhaEncontrada.EMISSAO_NFCE);
                        $('#txtProtocoloNF').val(dataUltimaLinhaEncontrada.PROTOCOLO_NFCE);
                        $('#txtReciboNF').val(dataUltimaLinhaEncontrada.RECIBO_NFCE);
                        $('#txtChaveNF').val(dataUltimaLinhaEncontrada.CHAVE_NFCE);
                        $('#txtChaveOffline').val(dataUltimaLinhaEncontrada.CHAVE_OFFLINE);
                    }

                    const componentesAEsconder = ['#btnImprimir', '#btnCancelar', '#btnExcluir', '#btnConsultar'];
                    const varreComponentesEModificaClasse = (desabilita) => {
                        for (let i = 0; i < componentesAEsconder.length; i++) {
                            const componente = componentesAEsconder[i];
                            if (desabilita) {
                                $(componente).addClass('d-none');
                            }
                            else {
                                $(componente).removeClass('d-none');
                            }
                        }
                    }
                    if (peloMenosUmSelecionado) {
                        varreComponentesEModificaClasse(true);
                    } else {
                        varreComponentesEModificaClasse(false);
                    }
                });
            }

            $('#tabelaNotas')
                .on('draw.dt', function () {
                    adicionaFuncaoSelecionar();
                })
                .dataTable();

        } finally {
            $.LoadingOverlay("hide");
            $('#modal-filtros').modal('hide');
        }
    });
    //   $('#btn-consultar').trigger('click');
    $('a[data-toggle="tab"]').on('shown.bs.tab', function () {
        $.fn.dataTable.tables({
            visible: true,
            api: true
        }).columns.adjust();
    });



    $('#tabelaNotas tbody').on('click', 'tr', async function () {
        if (gerarVarios) {
            const posicaoSelecionada = $(this).index();
            const campoEstaSelecionado = $($('.campoSel')[posicaoSelecionada]).prop('checked');
            $($('.campoSel')[posicaoSelecionada]).prop('checked', !campoEstaSelecionado).trigger('change');
        } else {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $('#tabelaNotas').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                if ($('#tabelaNotas').DataTable().rows().count() == 0) {
                    $('#txtNumeroNF').val('');
                    $('#txtSerieNF').val('');
                    $('#txtEmissaoNF').val('');
                    $('#txtProtocoloNF').val('');
                    $('#txtReciboNF').val('');
                    $('#txtChaveNF').val('');
                    $('#txtChaveOffline').val('');
                } else {
                    let data = $('#tabelaNotas').DataTable().row($(this)).data();
                    $('#txtNumeroNF').val(data.FATURA);
                    $('#txtSerieNF').val(data.SERIE);
                    $('#txtEmissaoNF').val(data.EMISSAO_NFCE);
                    $('#txtProtocoloNF').val(data.PROTOCOLO_NFCE);
                    $('#txtReciboNF').val(data.RECIBO_NFCE);
                    $('#txtChaveNF').val(data.CHAVE_NFCE);
                    $('#txtChaveOffline').val(data.CHAVE_OFFLINE);
                }
            }

        }
    });


    $('#tabelaNotas').on('click', '#btn-mostrar-itens', async function () {
        try {
            window.event.preventDefault();
            $.LoadingOverlay("show");

            if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

            let tr = this.closest('tr');
            let data = $('#tabelaNotas').DataTable().row($(tr)).data();
            let dados = await buscaItens(data.FATURA, data.SERIE);
            $('#txtNotaItens').val(data.FATURA);
            $('#txtSerieItens').val(data.SERIE);
            $('#modal-itens-title').html(`Itens da nota: ${data.FATURA}`);
            let dataSetCols = [];

            let keys = Object.keys(dados.RESULT[0][0]);
            // eslint-disable-next-line no-restricted-syntax, guard-for-in
            for (let k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            }

            // eslint-disable-next-line no-shadow
            dataSetCols[11].render = function (data, _type, _row, meta) {
                const prop = bloqNatureza ? 'disabled' : '';
                return `${'<div class="group-default form-group">' +
                    '<div class="relative">' +
                    '<input type="text" placeholder="Natureza" id="natureza_col_'}${[meta.row]}_row_${[meta.col]}" readonly ${prop} class="input-default focus form-control validate campoNatureza mt-3" value="${data}"> ` +
                    `</div>` +
                    `</div>`;
            };

            let decimais = parseInt(await CopiaParametro("SISTEMA", 1)) + 2;
            if (isNaN(decimais)) {
                decimais = 2;
            }

            tabelaItens = $('#tabelaItens').DataTable({
                paging: false,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                "data": dados.RESULT[0],
                "columns": dataSetCols,
                "columnDefs": [{
                    "targets": [12],
                    "visible": false
                },
                {
                    "render": function (data) {
                        return parseFloat(data).toLocaleString('pt-BR', {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    "targets": [6, 7, 8, 9, 10],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [5],
                    "className": 'pr-4 text-right'
                }],
            });

            if ($('#txtProtocoloNF').val() == '') {
                for (let i = 0; i < $('.campoNatureza').length; i++) {
                    $(`#natureza_col_${i}_row_10`).pesquisa(`#natureza_col_${i}_row_10`, 'NATUREZA', 'NATUREZA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":["natureza"], "where": ["tipo = ${"'V'"} and tp_base = '1'"]}`, 'Pesquisa Natureza', 'natureza', 'S');
                }
            }

            $('#modal-itens').modal('show');
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btn-Config').on('click', async function () {
        try {
            const url = '/sisplan/nfce/v1/buscarininfce?';
            const params = '';
            const response = await requisicao('GET', url, params, null);

            const jsonIni = await response.json();
            if (response.status != 200) {
                console.log(jsonIni.mensagem);
                msgAlerta(jsonIni.mensagem);
                return;
            }
            $('#txtVersao').val(jsonIni.versao);
            $('#txtIDCSC').val(jsonIni.iDCSC);
            $('#txtDiretorioLog').val(jsonIni.diretorioLog);
            $('#txtCSC').val(jsonIni.cSC);

            if (jsonIni.sincrono == 'S') {
                $('#txtSincrono').val('S');
            } else {
                $('#txtSincrono').val('N');
            }

            if (jsonIni.ambiente == '2') {
                $('#txtAmbiente').val('2');
            } else {
                $('#txtAmbiente').val('1');
            }
        } finally {
            $('#modal-Config').modal('show');
        }
    });

    $('#btn-confirmar-config').on('click', async function () {
        try {
            const params = '';
            const NFCE = {
                versao: $('#txtVersao').val(),
                idcsc: $('#txtIDCSC').val(),
                diretorioLog: $('#txtDiretorioLog').val(),
                csc: $('#txtCSC').val(),
                sincrono: $('#txtSincrono').val(),
                ambiente: $('#txtAmbiente').val()
            };
            const url = '/sisplan/nfce/v1/gravarininfce?';
            const response = await requisicao('POST', url, params, JSON.stringify(NFCE), 15000);
            console.log(response);

            if (response.status != 200) {
                const json = await response.json();
                msgAlerta(json.mensagem);
            }

            if (response.status == 200) {
                toastr.success(
                    'Configuração gravada com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        $('#modal-Config').modal('hide');
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            } else {
                return;
            }
        } finally {
            $('#modal-Config').modal('hide');
        }
    });

    $('#btnEmail').on('click', async function () {
        const tr = $('#tabelaNotas tr.selected')[0];
        if (tr == undefined) {
            msgAlerta('Selecione uma NFC-e para enviar e-mail.')
            return;
        }
        await enviaEmail();
    });

    $('#btn-consultar').trigger('click');

    async function enviaEmail() {
        const fatura = $('#txtNumeroNF').val();
        const serie = $('#txtSerieNF').val();
        const url = '/sisplan/nfce/v1/enviaremail?';
        try {
            try {
                $.LoadingOverlay("show");
                const response = await requisicao('POST', url, `FATURA=${fatura}&SERIE=${serie}&CODUSUARIO=${getCookie('cod_usuario')}`, null, 300000);
                if (!response) {
                    return;
                }
                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.mensagem)
                    return;
                }
                await msgSucesso(jsonStr.mensagem);
            } catch (error) {
                console.error(error);
                msgErro('Erro ao enviar e-mail');
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnVisualizar').on('click', async function () {

        if ($("#dropdownVisualizar")[0].classList[1] != "show") {
            $('#dropdownVisualizar').addClass("show");
        } else {
            $('#dropdownVisualizar').removeClass("show");
        }
    });

    $("#btnVisualizarXML").on("click", async function () {
        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        $.LoadingOverlay("show");
        const faturaNFE = $("#txtNumeroNF").val();
        const chaveNFE = $("#txtChaveNF").val();
        const protocoloNFE = $("#txtProtocoloNF").val();
        try {

            if (faturaNFE == "") {
                msgAlerta("Nenhuma nota selecionada, para realizar a ação é necessário selecionar uma nota.");
                return;
            }

            if (chaveNFE == "") {
                msgAlerta("Nota selecionada não possui chave, verifique.");
                return;
            }

            if (protocoloNFE == "") {
                msgAlerta("Nota fiscal não transmitida, deseja visualizar o pré XML?", async () => { await visualizarXML(chaveNFE) });
            } else {
                await visualizarXML(chaveNFE, protocoloNFE);
            }

        } finally {
            $.LoadingOverlay("hide");
            $('#dropdownVisualizar').removeClass("show");
        }
    });

    $("#btnBaixarXML").on("click", async function () {
        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;

        $.LoadingOverlay("show");
        const faturaNFE = $("#txtNumeroNF").val();
        const chaveNFE = $("#txtChaveNF").val();
        const protocoloNFE = $("#txtProtocoloNF").val();
        try {
            if (faturaNFE == "") {
                msgAlerta("Nenhuma nota selecionada, para realizar a ação é necessário selecionar uma nota.");
                return;
            }

            if (chaveNFE == "") {
                msgAlerta("Nota selecionada não possui chave, verifique.");
                return;
            }

            if (protocoloNFE == "") {
                msgAlerta("Nota fiscal não transmitida, deseja baixar o pré XML?", async () => { await baixarXML(chaveNFE) });
            } else {
                await baixarXML(chaveNFE, protocoloNFE);
            }

        } finally {
            $.LoadingOverlay("hide");
            $('#dropdownVisualizar').removeClass("show");
        }
    })

    async function visualizarXML(chave, protocolo = "") {
        try {
            const url = '/sisplan/nfce/v1/visualizarxmlnfce?';
            const params = `CHAVE_NFCE=${chave}&PROTOCOLO_NFCE=${protocolo}`;
            const response = await requisicao('GET', url, params, '', 180000);

            if (!response) {
                msgAlerta("Não foi possível realizar a ação.");
                return;
            }

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            }

            window.open(`${BASE_URI}/XMLtemp/XMLVisualizar.xml`, "_blank");

        } catch (error) {
            console.log(error);
        }
    };

    async function baixarXML(chave, protocolo = "") {
        try {
            const url = '/sisplan/nfce/v1/retornaxmlnfce?';
            const params = `CHAVE_NFCE=${chave}&PROTOCOLO_NFCE=${protocolo}`;
            const response = await requisicao('GET', url, params, '', 180000);

            if (!response) {
                msgAlerta("Não foi possível realizar a ação.");
                return;
            }

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            }

            const xml = await response.text();

            if (xml != '') {
                const file = new Blob([xml], { type: "text/xml" });
                const fileName = `NFe${chave}.xml`;
                saveAs(file, fileName);
            } else {
                msgAlerta('XML não encontrado!');
                return;
            }

        } catch (error) {
            console.log(error);
        }
    };
});