$('#txtClienteGenerico').autocompleta(1, `JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
$('#btnClienteGenerico').pesquisa_serverside(['#txtClienteGenerico'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa de Cliente');
$('#btnLimpaClienteGenerico').on('click', function () {
  $('#txtClienteGenerico').val('');
});

$('#txtBancoGenerico').autocompleta(1, `JSON={"tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
$('#btnBancoGenerico').pesquisa('#txtBancoGenerico', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, 'Pesquisa de Banco', 'CADBAN');
$('#btnLimpaBancoGenerico').on('click', function () {
  $('#txtBancoGenerico').val('');
});

$('#txtContaGenerico').autocompleta(1, `JSON={"tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnContaGenerico').pesquisa('#txtContaGenerico', 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, 'Pesquisa de Conta', 'CADCONTA');
$('#btnLimpaContaGenerico').on('click', function () {
  $('#txtContaGenerico').val('');
});

$('#txtClasseBaixaGenerico').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseBaixaGenerico').pesquisa_serverside(['#txtClasseBaixaGenerico'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Baixa');
$('#btnLimpaClasseBaixaGenerico').on('click', function () {
  $('#txtClasseBaixaGenerico').val('');
});

$('#txtClasseDespesaGenerico').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseDespesaGenerico').pesquisa_serverside(['#txtClasseDespesaGenerico'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Classe Despesa');
$('#btnLimpaClasseDespesaGenerico').on('click', function () {
  $('#txtClasseDespesaGenerico').val('');
});

$('#txtHistoricoGenerico').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnHistoricoGenerico').pesquisa_serverside(['#txtHistoricoGenerico'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaHistóricoGenerico').on('click', function () {
  $('#txtHistóricoGenerico').val('');
});

componenteFiltro('moeda', false, false, 'MoedaGenerico')

async function validaConfirmacao() {
  if (!$('#txtClasseBaixaGenerico').val() || !await Existe('CLASSE_GER', ['CODIGO'], [$('#txtClasseBaixaGenerico').val()])) {
    throw msgAlerta('Classe/Baixa não informado ou inválido!');
  }
  if (!$('#txtHistoricoGenerico').val() || !await Existe('HISTORICO', ['HISTCP'], [$('#txtHistoricoGenerico').val()])) {
  }
  throw msgAlerta('Histórico não informado ou inválido!');
}

$('#btnVerBaixasGenerico').on('click', async function () {
  if (!$('#txtArquivo').val()) {
    throw msgAlerta('Nenhum arquivo inserido no campo caminho, impossível visualizar as baixas!');
  }
  await verBaixasGenerico();
});

$('#txtContaGenerico').on('blur', async function () {
  if (!pegaChave(this)) return
  const banco = (await buscaValor('CADCONTA', 'BANCO', 'CONTA', pegaChave(this))).BANCO

  insereValor('#txtBancoGenerico', banco, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: banco })
});

function format(v) {
  if (!isNaN(v)) return parseFloat(v).toFixed(2).replace('.', ',');
  return v;
}

function convert(obj) {
  if (Array.isArray(obj)) return obj.map(convert);
  if (obj && typeof obj === 'object') {
    const res = {};
    for (const k in obj) res[k] = convert(obj[k]);
    return res;
  }
  return format(obj);
}

async function verBaixasGenerico() {
  $.LoadingOverlay('show');
  try {
    const rawData = window.databody.objeto;

    const body = {
      data: convert(rawData)
    };


    let response = await requisicao('POST', '/sisplan/escretorno/V1/buscabaixasgenerico?', `&FILE=${window.databody.file}&TAB=${'Generico'}`, JSON.stringify(body), 50000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();

    const dataSetCols = [];
    const keys = Object.keys(jsonStr[0]);
    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaGenerico').DataTable({
      paging: true,
      filter: false,
      info: false,
      length: false,
      order: false,
      destroy: true,
      data: jsonStr,
      columns: dataSetCols,
      columnDefs: [
        {
          targets: [0], render: function (_data, _type, _row, meta) {
            return `<div class="icheck-primary d-inline">
										<input type="checkbox" ${(_row.SEL === 'S' && _row.NAOSELECIONA === 'S') ? 'checked' : 'disabled'} id="check_col_${meta.row}_row_${meta.col}">
										<label for="check_col_${meta.row}_row_${meta.col}"></label>
									</div>`;
          },
        },
        {
          targets: [7, 8],
          render: function (data, type, row) {
            if (type === 'display' || type === 'filter') {
              var date = new Date(data);
              var dia = date.getDate();
              var mes = date.getMonth() + 1;
              var ano = date.getFullYear();
              if (dia < 10) {
                dia = '0' + dia;
              }
              if (mes < 10) {
                mes = '0' + mes;
              }
              return dia + '/' + mes + '/' + ano;
            } else {
              return data;
            }
          },
        }],
      rowCallback: async function (row, data) {
        if (data.NUMERO == '') {
          $(row).css('background-color', '#B4524D');
          $(row).css('color', '#ecfdff');
        }
        else if (data.NAOSELECIONA == 'N') {
          $(row).css('background-color', '#3A5E44');
          $(row).css('color', '#ecfdff');
        }
        else if (data.VALORDUPLICATA != data.VALORBRUTOARQ && data.VALORBRUTOARQ > 0) {
          $(row).css('background-color', '#04336C');
          $(row).css('color', '#ecfdff');
        }
      }
    });

    $('.campoSel').on('change', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });

  } catch (error) {
    console.log(error)
  } finally {
    $.LoadingOverlay('hide');
  }
}

$('#btnConfirmarGenerico').on('click', async function () {
  try {
    $.LoadingOverlay('show')

    const paramsReceber = await BuscaParametrosReceber();

    if (isEmpty($('#txtContaGenerico'))) {
      return msgAlerta('Conta não informada, verifique!')
    }
    if (isEmpty($('#txtBancoGenerico'))) {
      return msgAlerta('Banco não informado, verifique!')
    }
    if (paramsReceber[15].VALOR == '0' && isEmpty($('#txtClasseBaixaGenerico'))) {
      await msgAguardaConfirmacao('Classe/Baixa não informado, deseja utilizar a classe das Duplicatas?', () => { }, () => { throw new Error('Operação Cancelada!') })
    } else if (paramsReceber[15].VALOR == '1' && isEmpty($('#txtClasseBaixaGenerico'))) {
      return msgAlerta('Classe/Baixa não informado, verifique!')
    }
    if (isEmpty($('#txtClasseDespesaGenerico'))) {
      return msgAlerta('Conta não informada, verifique!')
    }
    if (isEmpty($('#txtHistoricoGenerico'))) {
      return msgAlerta('Histórico não informado, verifique!')
    }

    const data = $('#tabelaGenerico').DataTable().rows().data().toArray().filter(item => item.SEL == 'S')

    const body = {
      data: data,
      fields: coletaDadosInputsGenerico()
    }

    const response = await requisicao('POST', `/sisplan/escretorno/V1/confirmagenerico?`, ``, JSON.stringify(body), 90000);

    if (!response) {
      return;
    }
    if (response.status != 200) {
      msgErro(jsonStr.mensagem);
      return;
    }

    toastr.success(
      `Baixa realizada com sucesso!`,
      'Confirmação', {
      toastClass: 'alert',
      iconClasses: {
        error: 'alert-error',
        info: 'alert-info',
        success: 'alert-success',
        warning: 'alert-warning'
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      onHidden() {
        window.location.href = `${BASE_URI}/extrato_cartao`;
      }
    }
    ).css({
      "margin-top": "20%",
      "width": "500px",
      "max-width": "500px"
    });
  } catch (error) {
    console.log(error)
  } finally {
    $.LoadingOverlay('hide')
  }
});

function coletaDadosInputsGenerico() {
  let sugestao = 0;

  if ($('#cbValorGenerico').is(':checked')) {
    sugestao = 0;
  }
  if ($('#rgLiquidacaoNormalSafra').is(':checked')) {
    sugestao = 1;
  }
  if ($('#rgLiquidacaoAntecipadaSafra').is(':checked')) {
    sugestao = 2;
  }
  if ($('#rgLiquidadaAmortizacaoSafra').is(':checked')) {
    sugestao = 3;
  }

  objeto = {
    valorDe: $('#txtValorDeGenerico').val(),
    valorAte: $('#txtValorAteGenerico').val(),
    cliente: pegaChave('#txtClienteGenerico'),
    banco: pegaChave('#txtBancoGenerico'),
    conta: pegaChave('#txtContaGenerico'),
    classeBaixa: pegaChave('#txtClasseBaixaGenerico'),
    classeDespesa: pegaChave('#txtClasseDespesaGenerico'),
    historico: pegaChave('#txtHistoricoGenerico'),
    moeda: pegaChave('#txtMoedaGenerico'),
    dataPagamento: $('#dtPagamentoGenerico').val(),
    sugestao: sugestao,
  }
  return objeto;
}
