componenteFiltro("banco", false, false, "BancoAsaas");
componenteFiltro("conta", false, false, "ContaAsaas");
componenteFiltro("classe", false, false, "ClasseBaixaAsaas");
componenteFiltro("classe", false, false, "ClasseTaxaAsaas");
componenteFiltro("historico", false, false, "HistoricoAsaas");
componenteFiltro("moeda", false, false, "MoedaAsaas");

function criaDataTableAsaas() {
  $("#tabelaAsaas").DataTable({
    paging: true,
    filter: false,
    info: false,
    length: false,
    order: false,
    destroy: true,
    data: {},
    columns: dataSetColsAsaas,
    columnDefs: [
      {
        targets: [0], render: function (_data, _type, _row, meta) {
          return `<div class="icheck-primary d-inline">
										<input type="checkbox" ${(_row.SEL === 'S') ? 'checked' : 'disabled'} id="check_col_${meta.row}_row_${meta.col}">
										<label for="check_col_${meta.row}_row_${meta.col}"></label>
									</div>`;
        },
      },
      {
        type: 'date-br',
        targets: [10, 11, 12],
        render(data) {
          if (data) {
            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
          } else {
            return '';
          }

        },
      },
      {
        targets: [5, 6, 7, 15],
        render(data) {
          return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        },
        "className": 'pr-4 text-right'
      }
    ],
  });
};

$('#btnVerBaixasAsaas').on('click', async function () {
  insereDadosNaTabela();
});

$('#btnConfirmarAsaas').on('click', async function () {
  gravaDadosNaTabela(); 
});

function retornaFiltros() {
  const banco = pegaChave('#txtBancoAsaas');
  const conta = pegaChave('#txtContaAsaas');
  const classeBaixa = pegaChave('#txtClasseBaixaAsaas');
  const classeTaxa = pegaChave('#txtClasseTaxaAsaas');
  const historico = pegaChave('#txtHistoricoAsaas');
  const moeda = pegaChave('#txtMoedaAsaas');

  return `BANCO=${banco}&CONTA=${conta}&CLASSE_BAIXA=${classeBaixa}&CLASSE_TAXA=${classeTaxa}&HISTORICO=${historico}&MOEDA=${moeda}`;
};

async function insereDadosNaTabela() {
  $.LoadingOverlay('show');
  try {
    $('#tabelaAsaas').DataTable().clear().draw(false);
    
    const url = '/sisplan/escretorno/v1/buscabaixasasaas?';

    const params = retornaFiltros();

    const listaRegistrosAsaas = [];

    for (let i = 0; i < window.databody.length; i++) {
      const obj = {
        "sel": window.databody[i].sel,
        "nsu": window.databody[i].nsu,
        "parcela": window.databody[i].parcela,
        "dt_pagamento": window.databody[i].dt_pagamento,
      };
      listaRegistrosAsaas.push(obj);
    };

    let response = await requisicao('POST', url, `${params}&LISTA_REGISTROS=${JSON.stringify({ DATA: listaRegistrosAsaas })}`, ``);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (!jsonStr || jsonStr.length === 0) {
      msgAlerta('Não foi possível encontrar os dados das baixas do extrato de cartão Asaas. Por favor, tente novamente.');
      return
    };

    $('#tabelaAsaas').DataTable().rows.add(jsonStr).draw(false);
  } catch (error) {
    console.error(error);
    msgErro(`Ocorreu um erro ao ver as baixas do arquivo Asaas! Por favor, verifique. Erro: ${error}`)
  } finally {
    $.LoadingOverlay('hide');
  }
};

criaDataTableAsaas();

async function gravaDadosNaTabela() {
  $.LoadingOverlay('show');
  try {
    const url = '/sisplan/escretorno/v1/gravabaixasasaas?';

    const params = retornaFiltros();

    const listaBaixasAsaas = [];

    const dataTableAsaas = $('#tabelaAsaas').DataTable().rows().data();

    for (let i = 0; i < dataTableAsaas.length; i++) {
      if (dataTableAsaas[i].SEL === 'S') {
        const obj = {
          "NUMERO": dataTableAsaas[i].NUMERO,
          "CODCLI": dataTableAsaas[i].COD_CLI,
          "DT_PAGAMENTO": dataTableAsaas[i].DT_PAGAMENTO,
          "VALOR_LIQUIDO": dataTableAsaas[i].VALOR_LIQUIDO,
          "VALOR_PAGO": dataTableAsaas[i].VALOR_LIQUIDO,
          "DT_EMISSAO": dataTableAsaas[i].DT_EMISSAO,
          "FATURA": dataTableAsaas[i].FATURA,
        };
        listaBaixasAsaas.push(obj);
      }
    };
    if (listaBaixasAsaas.length === 0) {
      msgAlerta('Nenhum registro selecionado para baixa. Por favor, selecione ao menos um registro.');
      return;
    };

    let response = await requisicao('POST', url, `${params}&LISTA_BAIXAS=${JSON.stringify({ DATA: listaBaixasAsaas })}`, ``);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status !== 200) {
      msgAlerta('Não foi possível gravar os dados das baixas do extrato de cartão Asaas. Por favor, tente novamente.');
      return
    };

    msgSucesso('Baixas do arquivo Asaas gravadas com sucesso!');
    
    window.location.reload();
  } catch (error) {
    console.error(error);
    msgErro(`Ocorreu um erro ao gravar as baixas do arquivo Asaas! Por favor, verifique. Erro: ${error}`)
  } finally {
    $.LoadingOverlay('hide'); 
  }
}
