<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Veículo</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2511.18.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2511.18.1">
  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2511.18.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.2511.18.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2511.18.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.2511.18.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.2511.18.1">

  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2511.18.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2511.18.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2511.18.1">
  <!-- Google Font: Source Sans Pro -->
  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative
    }

    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .radioTipo {
      font-size: 120%;
    }

    .frete {
      margin-top: 2%;
      margin-left: 0.1%;
    }

    .checkboxOpcoes {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1.6%;
      padding-bottom: 0%;
    }

    .labelTipo {
      margin-bottom: 3px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">


    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
              </div>
            </div>
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Veículo
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account" style="font-size: 100%;"><strong>Geral</strong></li>
                        <li id="payment" style="font-size: 100%;"><strong>Dados Adicionais</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro do veículo</p>

                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <h2 class="fs-title">Dados Gerais</h2>
                          <div class="row">
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPlaca">Placa *</label>
                              <input type="text" class="input-default focus form-control" id="txtPlaca" required name="txtPlaca" class="form-control" placeholder="Placa">
                            </div>
                            <div class="col-lg-8 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtChassi">Chassi</label>
                              <input type="text" class="input-default focus form-control text-uppercase" id="txtChassi" aria-describedby="descError" name="txtChassi" class="form-control" placeholder="Chassi">
                            </div>
                            <div class="mt-4 pt-3">
                              <div class="icheck-primary">
                                <input class="ml-2" type="checkbox" checked id="checkAtivo">
                                <label class='' for="checkAtivo">Ativo</label>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-2 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarca">Marca *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMarca" required aria-describedby="histError" name="txtMarca" class="form-control" placeholder="Marca">
                              </div>
                            </div>
                            <div class="col-lg-7 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtModelo">Modelo *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtModelo" required aria-describedby="classeError" name="txtModelo" class="form-control" placeholder="Modelo">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtAno">Ano *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtAno" required aria-describedby="histError" name="txtAno" class="form-control" placeholder="Ano">
                              </div>
                            </div>
                            <div class="col-lg-4 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtProprietario">Proprietário</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtProprietario" name="txtProprietario" class="form-control" placeholder="Proprietário">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnProprietario" name="btnProprietario" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnExcluiProprietario" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-4 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMotorista">Motorista</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMotorista" name="txtMotorista" class="form-control" placeholder="Motorista">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnMotorista" name="btnMotorista" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnExcluiMotorista" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-4 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCidade">Cidade</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCidade" name="txtCidade" class="form-control" placeholder="Cidade">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCidade" name="btnCidade" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnExcluiCidade" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar1" class="btn-sisp next action-button" value="Avançar" id="avancar1" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card" id="contas">
                          <h2 class="fs-title">Dados Adicionais</h2>
                          <div class="row">
                            <div class="col-4 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="">Tipo Veículo: *</label>
                              <div class="relative">
                                <select name="" id="txtTipoVeiculo" value="" class="form-group input-default">
                                  <option value="" disabled selected>Selecione uma opção</option>
                                  <option value="0">0 - Tração</option>
                                  <option value="1">1 - Reboque</option>
                                </select>
                              </div>
                            </div>
                            <div class="col-4 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="">Tipo Carroceria: *</label>
                              <div class="relative">
                                <select name="" id="txtTipoCarroceria" value="" class="form-group input-default">
                                  <option value="" disabled selected>Selecione uma opção</option>
                                  <option value="0">0 - Não aplicável</option>
                                  <option value="1">1 - Aberta</option>
                                  <option value="2">2 - Fechada - Baú</option>
                                  <option value="3">3 - Granelera</option>
                                  <option value="4">4 - Porta Container</option>
                                  <option value="5">5 - Sider</option>
                                  <option value="6">6 - Tanque</option>
                                </select>
                              </div>
                            </div>
                            <div class="col-4 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="">Tipo Rodado: *</label>
                              <div class="relative">
                                <select name="" id="txtTipoRodado" value="" class="form-group input-default">
                                  <option value="" disabled selected>Selecione uma opção</option>
                                  <option value="0">0 - Não Aplicável</option>
                                  <option value="1">1 - Truck</option>
                                  <option value="2">2 - Toco</option>
                                  <option value="3">3 - Cavalo Mec</option>
                                  <option value="4">4 - Van</option>
                                  <option value="5">5 - Utilitário</option>
                                  <option value="6">6 - Outros</option>
                                </select>
                              </div>
                            </div>
                            <div class="col-3 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="">UF Licenciamento: *</label>
                              <div class="relative">
                                <select name="" id="txtUF" value="" class="form-group input-default">
                                  <option value="" disabled selected>Selecione uma opção</option>
                                </select>
                              </div>
                            </div>
                            <div class="col-lg-4 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtApolice">Apolice</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtApolice" name="txtApolice" class="form-control" placeholder="Apolice">
                              </div>
                            </div>
                            <div class="col-3" style="margin-top: 3px;">
                              <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right">Vencimento: </label>
                              <div class="relative" style="margin-top: 5px;">
                                <div class="input-group">
                                  <input type="date" max="2500-12-31" class="input-default focus form-control mr-1" id="dtVencimento" value="1200-01-01" name="dtVencimento" class="form-control">
                                </div>
                              </div>
                            </div>
                            <div class="col-2 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtValor">Valor</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtValor" name="txtValor" class="form-control" placeholder="Valor">
                              </div>
                            </div>
                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSeguradora">Seguradora</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtSeguradora" name="txtSeguradora" class="form-control" placeholder="Seguradora">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnSeguradora" name="btnTSeguradora" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnASeguradora" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-3" style="margin-top: 3px;">
                              <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right">Vencimento IPVA: </label>
                              <div class="relative" style="margin-top: 5px;">
                                <div class="input-group">
                                  <input type="date" max="2500-12-31" class="input-default focus form-control mr-1" id="dtVencimentoIPVA" value="1200-01-01" name="dtVencimentoIPVA" class="form-control">
                                </div>
                              </div>
                            </div>
                            <div class="col-3 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorIPVA">Valor IPVA</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtValorIPVA" name="txtValorIPVA" class="form-control" placeholder="Valor IPVA">
                              </div>
                            </div>
                            <div class="col-3" style="margin-top: 3px;">
                              <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right">Vencimento Licenc.: </label>
                              <div class="relative" style="margin-top: 5px;">
                                <div class="input-group">
                                  <input type="date" max="2500-12-31" class="input-default focus form-control mr-1" id="dtVencimentoLicenciamento" value="1200-01-01" name="dtVencimentoLicenciamento" class="form-control">
                                </div>
                              </div>
                            </div>
                            <div class="col-3 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorLicenciamento">Valor Licenc.</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtValorLicenciamento" name="txtValorLicenciamento" class="form-control" placeholder="Valor Licenciamento">
                              </div>
                            </div>
                            <div class="col-3" style="margin-top: 3px;">
                              <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right">Vencimento Seg: </label>
                              <div class="relative" style="margin-top: 5px;">
                                <div class="input-group">
                                  <input type="date" max="2500-12-31" class="input-default focus form-control mr-1" id="dtVencimentoSegObrig" value="1200-01-01" name="dtVencimentoSegObrig" class="form-control">
                                </div>
                              </div>
                            </div>
                            <div class="col-3 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorSegObrig">Valor Seg</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtValorSegObrig" name="txtValorSegObrig" class="form-control" placeholder="Valor Seg. Obrigatório">
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="gravar" class="action-button" value="Gravar" id="gravar">
                        <input type="button" name="voltar2" class="previous action-button-previous" value="Voltar" id="voltar2" />
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
</body>

<?php
include_once('../../../modais.php');
?>

<!-- Control Sidebar -->
<aside class="control-sidebar control-sidebar-dark">
  <!-- Control sidebar content goes here -->
</aside>
<!-- /.control-sidebar -->
</div>

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js?versao=3.2511.18.1"></script>
<script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.18.1"></script>
<script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2511.18.1"></script>
<script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2511.18.1"></script>
<script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2511.18.1"></script>
<script src="../plugins/toastr/toastr.min.js?versao=3.2511.18.1"></script>
<script>
  $.widget.bridge('uibutton', $.ui.button);
</script>
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.18.1"></script>
<script src="../dist/js/adminlte.min.js?versao=3.2511.18.1"></script>
<script src="../dist/js/requisicoes.js?versao=3.2511.18.1"></script>
<script src="../dist/js/cliente/entidade.js?versao=3.2511.18.1"></script>
<script src="../dist/js/loadingoverlay.min.js?versao=3.2511.18.1"></script>
<script src="../dist/js/valida_cpf_cnpj.js?versao=3.2511.18.1"></script>
<script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.18.1"></script>
<script src="../dist/js/sisplan.js?versao=3.2511.18.1"></script>
<script src="../utils/funcoes.js?versao=3.2511.18.1"></script>
<script src="../utils/cookies.js?versao=3.2511.18.1"></script>
<script src="../dist/js/jquery.mask.min.js?versao=3.2511.18.1"></script>
<script src="../dist/js/jquery.maskMoney.min.js?versao=3.2511.18.1"></script>
<script src="../dist/js/driver.min.js?versao=3.2511.18.1"></script>
<script src="../dist/js/dataTables.keyTable2.js?versao=3.2511.18.1"></script>
<script type="text/javascript" src="../config.js?versao=3.2511.18.1"></script>
<script>
  $(document).ready(async function() {
    if (getCookie('usuario') == "") {
      window.location.href = `${BASE_URI}/login`;
      return;
    }

    let usuario = getCookie('usuario');
    let empresa = getCookie('empresa');

    ipInterno = IP_INTERNO;
    ipExterno = IP_EXTERNO;
    basicAuth = BASIC_AUTH;

    const temAcesso = await temAcessoTela('CADVEICULO');
    if (!temAcesso.resultado) {
      toastrAcesso(temAcesso, BASE_URI);
      return;
    }

    const permissaoUsuarioLogado = await permissaoAcessos("CADVEICULO");

    if (permissaoUsuarioLogado.INCLUI == 'N') {
      await criaMensagemErro("Sem permissão para incluir!", () => {
        window.location.href = `${BASE_URI}/cadveiculo`
      });
      return;
    }

    const queryString = window.location.href;
    const parametros = queryString.split("/");
    const veiculo = parametros[parametros.length - 1];

    $(window).on("beforeunload", function(e) {
      e.stopPropagation();
      deletaRegistro("CADVEICULO", getCookie("usuario"), veiculo);
      return undefined;
    });

    sArquivo = `${BASE_URI}/pages/cadveiculo/cadastro_cadveiculo/cadveiculo.js?versao=3.2511.18.1`;
    insereJavaScriptPagina(sArquivo);

    const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
    habilitaCamposObrigatoriosTela(nomeTela);
  });
</script>
</body>

</html>